/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class RavenousJawModel<T extends LivingEntity>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"ravanousjawmodel"), "main");
    public final ModelPart jaw;
    private final ModelPart rightFangTop;
    private final ModelPart leftFangTop;
    private final ModelPart extendedJaw;

    public RavenousJawModel() {
        ModelPart root = RavenousJawModel.createBodyLayer().bakeRoot();
        this.jaw = root.getChild("jaw");
        this.rightFangTop = this.jaw.getChild("rightFangTop");
        this.leftFangTop = this.jaw.getChild("leftFangTop");
        this.extendedJaw = this.jaw.getChild("extendedJaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition jaw = partdefinition.addOrReplaceChild("jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFangTop = jaw.addOrReplaceChild("rightFangTop", CubeListBuilder.create().texOffs(0, 10).addBox(-0.7759f, -0.9047f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-4.5f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition cube_r1 = rightFangTop.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -1.0f, -3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2759f, (float)0.5953f, (float)-2.75f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = rightFangTop.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(6, 10).addBox(-1.0f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2241f, (float)0.0953f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftFangTop = jaw.addOrReplaceChild("leftFangTop", CubeListBuilder.create().texOffs(12, 5).addBox(-0.2241f, -0.9047f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)4.5f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition cube_r3 = leftFangTop.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(6, 5).addBox(0.0f, -1.0f, -3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2759f, (float)0.5953f, (float)-2.75f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = leftFangTop.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(12, 9).addBox(0.0f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2241f, (float)0.0953f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition extendedJaw = jaw.addOrReplaceChild("extendedJaw", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -0.5f, -2.5f, 11.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(10, 14).addBox(-2.0f, -2.75f, -3.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(14, 13).addBox(1.0f, -2.75f, -3.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.5f));
        PartDefinition fang_r1 = extendedJaw.addOrReplaceChild("fang_r1", CubeListBuilder.create().texOffs(4, 14).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(2, 14).addBox(2.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)-2.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition fang_r2 = extendedJaw.addOrReplaceChild("fang_r2", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 13).addBox(-7.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)-2.5f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition fang_r3 = extendedJaw.addOrReplaceChild("fang_r3", CubeListBuilder.create().texOffs(8, 14).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.25f, (float)0.0f, (float)-2.25f, (float)0.7854f, (float)-0.9599f, (float)0.0f));
        PartDefinition fang_r4 = extendedJaw.addOrReplaceChild("fang_r4", CubeListBuilder.create().texOffs(6, 14).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.25f, (float)0.0f, (float)-2.25f, (float)0.7854f, (float)0.9599f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float val = Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f;
        this.animateTentacleX(this.leftFangTop, val);
        this.animateTentacleX(this.rightFangTop, val);
        this.animateTentacleX(this.extendedJaw, -val);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.jaw.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

