/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Animations.ScavengerAnimations;
import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scavenger;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class ScavengerModel<T extends Scavenger>
extends HierarchicalModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"scavengermodel"), "main");
    private final ModelPart scavenger;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightForLeg;
    private final ModelPart leftForLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tail5;
    private final ModelPart Tumor1;
    private final ModelPart Tumor2;
    private final ModelPart Tumor3;
    private final ModelPart Neck1;
    private final ModelPart Neck2;
    private final ModelPart Head;
    private final ModelPart Tumor4;
    private final ModelPart Jaw;
    private final ModelPart Fang1;
    private final ModelPart Fang2;
    private final ModelPart Fang3;
    private final ModelPart Fang4;
    private final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ScavengerModel(ModelPart root) {
        this.scavenger = root.getChild("scavenger");
        this.rightLeg = this.scavenger.getChild("Legs").getChild("RightLeg");
        this.leftLeg = this.scavenger.getChild("Legs").getChild("LeftLeg");
        this.rightForLeg = this.rightLeg.getChild("RightLegSeg2");
        this.leftForLeg = this.leftLeg.getChild("LeftLegSeg2");
        this.rightWing = this.scavenger.getChild("LowerTorso").getChild("UpperTorso").getChild("Arms").getChild("Right");
        this.leftWing = this.scavenger.getChild("LowerTorso").getChild("UpperTorso").getChild("Arms").getChild("Left");
        this.tail1 = this.scavenger.getChild("LowerTorso").getChild("Tail");
        this.tail2 = this.tail1.getChild("Tail2");
        this.tail3 = this.tail2.getChild("Tail3");
        this.tail4 = this.tail3.getChild("Tail4");
        this.tail5 = this.tail4.getChild("Tail5");
        this.Tumor1 = this.scavenger.getChild("LowerTorso").getChild("TailTumors");
        this.Tumor2 = this.tail2.getChild("Tail2Tumors");
        this.Tumor3 = this.rightWing.getChild("RightSeg1").getChild("RightSeg2").getChild("RightSeg3").getChild("RightTumors");
        this.Neck1 = this.scavenger.getChild("LowerTorso").getChild("UpperTorso").getChild("Neck");
        this.Neck2 = this.Neck1.getChild("Neck2");
        this.Head = this.Neck2.getChild("Neck3").getChild("Head");
        this.Tumor4 = this.Head.getChild("Tumors");
        this.Jaw = this.Head.getChild("Jaw");
        this.Fang1 = this.Head.getChild("UpperRightFang");
        this.Fang2 = this.Head.getChild("UpperLeftFang");
        this.Fang3 = this.Jaw.getChild("LowerRightFang");
        this.Fang4 = this.Jaw.getChild("LowerLeftFang");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition scavenger = partdefinition.addOrReplaceChild("scavenger", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition LowerTorso = scavenger.addOrReplaceChild("LowerTorso", CubeListBuilder.create().texOffs(30, 14).addBox(-4.0f, -7.0f, -2.0f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.3986f, (float)3.9074f, (float)1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition UpperTorso = LowerTorso.addOrReplaceChild("UpperTorso", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -3.0f, 10.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition HunchPlaneBack_r1 = UpperTorso.addOrReplaceChild("HunchPlaneBack_r1", CubeListBuilder.create().texOffs(98, 36).addBox(0.0f, -2.5f, 0.5f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(58, 0).addBox(-4.0f, -0.5f, -2.5f, 8.0f, 8.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.7686f, (float)4.5095f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition HunchPlaneFront_r1 = UpperTorso.addOrReplaceChild("HunchPlaneFront_r1", CubeListBuilder.create().texOffs(42, 98).addBox(-0.01f, -1.0f, 0.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-5.0f, 0.0f, -5.0f, 10.0f, 6.0f, 5.0f, new CubeDeformation(-0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.8616f, (float)2.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = UpperTorso.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(62, 81).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(106, 53).addBox(0.0f, -4.0f, 2.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-0.25f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition Neck2 = Neck.addOrReplaceChild("Neck2", CubeListBuilder.create().texOffs(62, 81).mirror().addBox(-2.0f, -4.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-0.25f)).mirror(false).texOffs(106, 46).addBox(-0.01f, -3.25f, 1.5f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Neck3 = Neck2.addOrReplaceChild("Neck3", CubeListBuilder.create().texOffs(86, 92).addBox(-1.5f, -4.5f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(16, 84).addBox(0.0f, -4.5f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck3.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(48, 19).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.25f, (float)0.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(0, 76).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition LowerRightFang = Jaw.addOrReplaceChild("LowerRightFang", CubeListBuilder.create().texOffs(104, 0).addBox(-1.0f, -4.0f, -0.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6029f, (float)-4.8324f, (float)-1.514f, (float)0.2517f, (float)0.2494f, (float)-0.0804f));
        PartDefinition Plane_r1 = LowerRightFang.addOrReplaceChild("Plane_r1", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -2.0f, -3.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)3.1416f));
        PartDefinition LowerLeftFang = Jaw.addOrReplaceChild("LowerLeftFang", CubeListBuilder.create().texOffs(104, 0).addBox(-1.0f, -4.0f, -0.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6029f, (float)-4.8324f, (float)-1.514f, (float)0.2517f, (float)-0.2494f, (float)0.0804f));
        PartDefinition Plane_r2 = LowerLeftFang.addOrReplaceChild("Plane_r2", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -2.0f, -3.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)3.1416f));
        PartDefinition UpperRightFang = Head.addOrReplaceChild("UpperRightFang", CubeListBuilder.create().texOffs(104, 0).addBox(-1.0f, -3.0f, -1.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-4.3007f, (float)-0.5463f, (float)0.3155f, (float)-0.2494f, (float)-0.0804f));
        PartDefinition Plane_r3 = UpperRightFang.addOrReplaceChild("Plane_r3", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -3.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.5f, (float)-2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition UpperLeftFang = Head.addOrReplaceChild("UpperLeftFang", CubeListBuilder.create().texOffs(104, 0).addBox(-1.0f, -3.0f, -1.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.3007f, (float)-0.5463f, (float)0.3155f, (float)0.2494f, (float)0.0804f));
        PartDefinition Plane_r4 = UpperLeftFang.addOrReplaceChild("Plane_r4", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -3.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.5f, (float)-2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition Tumors = Head.addOrReplaceChild("Tumors", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.2209f, (float)-0.3616f, (float)2.8002f, (float)-0.3054f, (float)-0.6981f, (float)0.0f));
        PartDefinition Tumor_r1 = Tumors.addOrReplaceChild("Tumor_r1", CubeListBuilder.create().texOffs(0, 84).addBox(1.5f, -1.5f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.5569f, (float)3.0453f, (float)2.3457f, (float)0.3312f, (float)0.6681f, (float)-0.7794f));
        PartDefinition Tumor_r2 = Tumors.addOrReplaceChild("Tumor_r2", CubeListBuilder.create().texOffs(2, 85).addBox(-1.75f, -1.5f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.3875f, (float)-0.383f, (float)-0.3346f, (float)0.6625f, (float)0.0949f, (float)0.6994f));
        PartDefinition Tumor_r3 = Tumors.addOrReplaceChild("Tumor_r3", CubeListBuilder.create().texOffs(0, 84).addBox(-1.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.8667f, (float)-1.3456f, (float)0.831f, (float)0.9163f, (float)0.5236f, (float)0.0f));
        PartDefinition HeadCrown = Head.addOrReplaceChild("HeadCrown", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.088f, (float)0.1653f, (float)1.7805f, (float)0.0f, (float)0.0f, (float)1.8762f));
        PartDefinition Petal4_r1 = HeadCrown.addOrReplaceChild("Petal4_r1", CubeListBuilder.create().texOffs(-7, 44).addBox(-2.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal3_r1 = HeadCrown.addOrReplaceChild("Petal3_r1", CubeListBuilder.create().texOffs(-7, 37).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)-0.1603f, (float)-0.1693f));
        PartDefinition Petal2_r1 = HeadCrown.addOrReplaceChild("Petal2_r1", CubeListBuilder.create().texOffs(-7, 37).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r1 = HeadCrown.addOrReplaceChild("Petal1_r1", CubeListBuilder.create().texOffs(-7, 44).addBox(-4.0f, 0.0f, -5.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)4.0399f, (float)0.3838f, (float)0.2129f, (float)-0.4821f));
        PartDefinition Arms = UpperTorso.addOrReplaceChild("Arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)1.0f));
        PartDefinition Left = Arms.addOrReplaceChild("Left", CubeListBuilder.create().texOffs(0, 92).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition LeftSeg1 = Left.addOrReplaceChild("LeftSeg1", CubeListBuilder.create().texOffs(0, 64).addBox(-1.0f, -1.5f, -1.5f, 10.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(56, 42).addBox(-4.0f, 1.5f, 0.25f, 13.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition LeftArmFungus = LeftSeg1.addOrReplaceChild("LeftArmFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.9373f, (float)-1.864f, (float)1.745f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition Fungus_r1 = LeftArmFungus.addOrReplaceChild("Fungus_r1", CubeListBuilder.create().texOffs(-7, 44).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)-4.2108f, (float)-1.1025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r2 = LeftArmFungus.addOrReplaceChild("Fungus_r2", CubeListBuilder.create().texOffs(-7, 37).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5593f, (float)-2.2108f, (float)-2.1025f, (float)-0.2664f, (float)-0.4504f, (float)0.3859f));
        PartDefinition Fungus_r3 = LeftArmFungus.addOrReplaceChild("Fungus_r3", CubeListBuilder.create().texOffs(-7, 51).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.322f, (float)0.6324f, (float)0.3074f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r4 = LeftArmFungus.addOrReplaceChild("Fungus_r4", CubeListBuilder.create().texOffs(-7, 51).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)2.7892f, (float)-2.1025f, (float)0.0037f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition LeftSeg2 = LeftSeg1.addOrReplaceChild("LeftSeg2", CubeListBuilder.create().texOffs(96, 0).addBox(0.0f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(82, 9).mirror().addBox(-6.0f, -1.0f, 0.5f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)8.0839f, (float)0.0f, (float)-0.1515f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition LeftSeg3 = LeftSeg2.addOrReplaceChild("LeftSeg3", CubeListBuilder.create().texOffs(20, 78).addBox(-0.75f, -0.25f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)).texOffs(0, 58).mirror().addBox(-5.75f, 0.75f, 0.0f, 14.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition LeftTipFungus = LeftSeg3.addOrReplaceChild("LeftTipFungus", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Plane_r5 = LeftTipFungus.addOrReplaceChild("Plane_r5", CubeListBuilder.create().texOffs(0, 30).addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)0.5f, (float)0.5f, (float)0.7854f, (float)0.0f, (float)-0.4363f));
        PartDefinition LeftWingTalons = LeftSeg3.addOrReplaceChild("LeftWingTalons", CubeListBuilder.create(), PartPose.offset((float)7.4161f, (float)-2.0507f, (float)0.8552f));
        PartDefinition Plane_r6 = LeftWingTalons.addOrReplaceChild("Plane_r6", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -1.0f, -2.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0567f, (float)2.9968f, (float)-1.2271f, (float)-1.2075f, (float)-0.0174f, (float)-1.5814f));
        PartDefinition Plane_r7 = LeftWingTalons.addOrReplaceChild("Plane_r7", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -1.0f, -2.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.204f, (float)3.3802f, (float)-1.1384f, (float)-2.8236f, (float)-0.0829f, (float)2.0346f));
        PartDefinition Plane_r8 = LeftWingTalons.addOrReplaceChild("Plane_r8", CubeListBuilder.create().texOffs(99, 50).mirror().addBox(0.0f, -1.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.2515f, (float)2.2044f, (float)-0.3967f, (float)-2.8235f, (float)-0.5492f, (float)0.8264f));
        PartDefinition Right = Arms.addOrReplaceChild("Right", CubeListBuilder.create().texOffs(0, 92).mirror().addBox(-2.0f, -2.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition RightSeg1 = Right.addOrReplaceChild("RightSeg1", CubeListBuilder.create().texOffs(0, 64).mirror().addBox(-9.0f, -1.5f, -1.5f, 10.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(56, 42).mirror().addBox(-9.0f, 1.5f, 0.25f, 13.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition RightSeg2 = RightSeg1.addOrReplaceChild("RightSeg2", CubeListBuilder.create().texOffs(96, 0).mirror().addBox(-2.0f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(82, 9).addBox(-1.0f, -1.0f, 0.5f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0839f, (float)0.0f, (float)-0.1515f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition RightFungus = RightSeg2.addOrReplaceChild("RightFungus", CubeListBuilder.create(), PartPose.offset((float)-2.9754f, (float)6.5594f, (float)1.8966f));
        PartDefinition Fungus_r5 = RightFungus.addOrReplaceChild("Fungus_r5", CubeListBuilder.create().texOffs(-7, 51).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)-4.2108f, (float)-1.1025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r6 = RightFungus.addOrReplaceChild("Fungus_r6", CubeListBuilder.create().texOffs(-7, 37).addBox(-3.5f, -3.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)2.7892f, (float)-2.1025f, (float)0.0037f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition RightSeg3 = RightSeg2.addOrReplaceChild("RightSeg3", CubeListBuilder.create().texOffs(20, 78).mirror().addBox(-8.25f, -0.25f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)).mirror(false).texOffs(0, 58).addBox(-8.25f, 0.75f, 0.0f, 14.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition RightTumors = RightSeg3.addOrReplaceChild("RightTumors", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)2.0f, (float)0.0f));
        PartDefinition Tumor_r4 = RightTumors.addOrReplaceChild("Tumor_r4", CubeListBuilder.create().texOffs(0, 84).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8231f, (float)-0.7281f, (float)-0.4329f, (float)0.1805f, (float)0.6838f, (float)0.452f));
        PartDefinition Tumor_r5 = RightTumors.addOrReplaceChild("Tumor_r5", CubeListBuilder.create().texOffs(1, 86).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)-0.3491f));
        PartDefinition RightWingTalons = RightSeg3.addOrReplaceChild("RightWingTalons", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-8.579f, (float)0.8498f, (float)0.2383f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition Plane_r9 = RightWingTalons.addOrReplaceChild("Plane_r9", CubeListBuilder.create().texOffs(99, 50).addBox(0.0f, -1.0f, -2.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1063f, (float)0.1755f, (float)0.5051f, (float)-0.553f, (float)0.0174f, (float)1.5814f));
        PartDefinition Plane_r10 = RightWingTalons.addOrReplaceChild("Plane_r10", CubeListBuilder.create().texOffs(99, 50).addBox(0.0f, -1.0f, -2.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3669f, (float)0.559f, (float)0.5938f, (float)3.0669f, (float)0.0829f, (float)-2.0346f));
        PartDefinition Plane_r11 = RightWingTalons.addOrReplaceChild("Plane_r11", CubeListBuilder.create().texOffs(99, 50).addBox(0.0f, -1.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.9114f, (float)-0.6169f, (float)1.3356f, (float)2.9361f, (float)0.5492f, (float)-0.8264f));
        PartDefinition TorsoFlower = UpperTorso.addOrReplaceChild("TorsoFlower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.317f, (float)-3.7718f, (float)-2.615f, (float)1.609f, (float)-0.1526f, (float)-0.5298f));
        PartDefinition cube_r1 = TorsoFlower.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-7, 37).addBox(-7.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = TorsoFlower.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(-7, 51).addBox(0.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r3 = TorsoFlower.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-7, 37).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = TorsoFlower.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-7, 44).addBox(-4.0f, 0.0f, -7.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition UpperTorsoFungus = UpperTorso.addOrReplaceChild("UpperTorsoFungus", CubeListBuilder.create(), PartPose.offset((float)-4.0593f, (float)-0.4406f, (float)4.745f));
        PartDefinition Fungus_r7 = UpperTorsoFungus.addOrReplaceChild("Fungus_r7", CubeListBuilder.create().texOffs(-7, 44).addBox(-3.5f, 1.25f, -3.25f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.8685f, (float)-4.5866f, (float)-1.9219f, (float)0.7634f, (float)0.1482f, (float)0.7943f));
        PartDefinition Fungus_r8 = UpperTorsoFungus.addOrReplaceChild("Fungus_r8", CubeListBuilder.create().texOffs(-7, 51).addBox(-3.5f, 0.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5593f, (float)-2.2108f, (float)-2.1025f, (float)-0.2664f, (float)-0.4504f, (float)0.3859f));
        PartDefinition Fungus_r9 = UpperTorsoFungus.addOrReplaceChild("Fungus_r9", CubeListBuilder.create().texOffs(-7, 51).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.5575f, (float)2.8681f, (float)-0.7511f, (float)-0.3667f, (float)0.5152f, (float)-0.3599f));
        PartDefinition Fungus_r10 = UpperTorsoFungus.addOrReplaceChild("Fungus_r10", CubeListBuilder.create().texOffs(-7, 44).addBox(-4.5f, -1.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)2.7892f, (float)-2.1025f, (float)-0.3719f, (float)-0.2779f, (float)-0.4546f));
        PartDefinition TailTumors = LowerTorso.addOrReplaceChild("TailTumors", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.1618f, (float)0.1664f, (float)1.4628f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tumor_r6 = TailTumors.addOrReplaceChild("Tumor_r6", CubeListBuilder.create().texOffs(0, 84).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2559f, (float)2.4151f, (float)-2.5344f, (float)-0.2516f, (float)0.9236f, (float)-0.8615f));
        PartDefinition Tumor_r7 = TailTumors.addOrReplaceChild("Tumor_r7", CubeListBuilder.create().texOffs(0, 84).addBox(3.5f, -3.5f, -1.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.5569f, (float)3.0453f, (float)2.3457f, (float)0.3312f, (float)0.6681f, (float)-0.7794f));
        PartDefinition Tumor_r8 = TailTumors.addOrReplaceChild("Tumor_r8", CubeListBuilder.create().texOffs(0, 84).addBox(-1.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.8667f, (float)-1.3456f, (float)0.831f, (float)0.9163f, (float)0.5236f, (float)0.0f));
        PartDefinition Tail = LowerTorso.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(48, 90).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.5f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(60, 90).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2Tumors = Tail2.addOrReplaceChild("Tail2Tumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tumor_r9 = Tail2Tumors.addOrReplaceChild("Tumor_r9", CubeListBuilder.create().texOffs(2, 86).addBox(-2.0f, -2.5f, -4.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)1.4723f, (float)4.3913f, (float)0.1382f, (float)-0.7804f, (float)0.1267f, (float)-0.4738f));
        PartDefinition Tumor_r10 = Tail2Tumors.addOrReplaceChild("Tumor_r10", CubeListBuilder.create().texOffs(2, 86).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.4723f, (float)4.3913f, (float)0.1382f, (float)-0.6743f, (float)-1.0812f, (float)0.1796f));
        PartDefinition Tumor_r11 = Tail2Tumors.addOrReplaceChild("Tumor_r11", CubeListBuilder.create().texOffs(2, 86).addBox(-0.5f, -0.75f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-0.5f, (float)5.5f, (float)0.5f, (float)0.7681f, (float)-0.7749f, (float)-0.1378f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(98, 92).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)0.0f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition Tail4 = Tail3.addOrReplaceChild("Tail4", CubeListBuilder.create().texOffs(0, 100).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)5.4237f, (float)-0.0535f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition Tail5 = Tail4.addOrReplaceChild("Tail5", CubeListBuilder.create().texOffs(104, 74).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition TailTalon_r1 = Tail5.addOrReplaceChild("TailTalon_r1", CubeListBuilder.create().texOffs(22, 98).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TailTalon_r2 = Tail5.addOrReplaceChild("TailTalon_r2", CubeListBuilder.create().texOffs(32, 98).mirror().addBox(-2.5f, -3.5f, 0.0f, 5.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Legs = scavenger.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = Legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(92, 74).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-11.0f, (float)3.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegSeg2 = LeftLeg.addOrReplaceChild("LeftLegSeg2", CubeListBuilder.create().texOffs(82, 42).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLegFoot = LeftLegSeg2.addOrReplaceChild("LeftLegFoot", CubeListBuilder.create().texOffs(100, 31).addBox(-1.0f, -1.0f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)1.0f, (float)5.0f));
        PartDefinition FrontTalon3_r1 = LeftLegFoot.addOrReplaceChild("FrontTalon3_r1", CubeListBuilder.create().texOffs(100, 24).addBox(0.4617f, -1.692f, -2.384f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)4.25f, (float)-0.75f, (float)0.7968f, (float)-0.268f, (float)-0.4031f));
        PartDefinition FrontTalon2_r1 = LeftLegFoot.addOrReplaceChild("FrontTalon2_r1", CubeListBuilder.create().texOffs(100, 24).addBox(0.0f, -1.7164f, -2.2737f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)4.25f, (float)-0.75f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition FrontTalon1_r1 = LeftLegFoot.addOrReplaceChild("FrontTalon1_r1", CubeListBuilder.create().texOffs(100, 24).addBox(-0.4617f, -1.692f, -2.384f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.25f, (float)-0.75f, (float)0.7968f, (float)0.268f, (float)0.4031f));
        PartDefinition BackTalon_r1 = LeftLegFoot.addOrReplaceChild("BackTalon_r1", CubeListBuilder.create().texOffs(98, 49).addBox(0.0f, -4.9526f, -2.7891f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition FrontFoot_r1 = LeftLegFoot.addOrReplaceChild("FrontFoot_r1", CubeListBuilder.create().texOffs(96, 12).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.5f, (float)2.0f, (float)1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = Legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(92, 74).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-11.0f, (float)3.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegSeg2 = RightLeg.addOrReplaceChild("RightLegSeg2", CubeListBuilder.create().texOffs(82, 42).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLegFoot = RightLegSeg2.addOrReplaceChild("RightLegFoot", CubeListBuilder.create().texOffs(100, 31).addBox(-2.0f, -1.0f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)1.0f, (float)5.0f));
        PartDefinition FrontTalon3_r2 = RightLegFoot.addOrReplaceChild("FrontTalon3_r2", CubeListBuilder.create().texOffs(100, 24).addBox(-0.4617f, -1.692f, -2.384f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)4.25f, (float)-0.75f, (float)0.7968f, (float)0.268f, (float)0.4031f));
        PartDefinition FrontTalon2_r2 = RightLegFoot.addOrReplaceChild("FrontTalon2_r2", CubeListBuilder.create().texOffs(100, 24).addBox(0.0f, -1.7164f, -2.2737f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.25f, (float)-0.75f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition FrontTalon1_r2 = RightLegFoot.addOrReplaceChild("FrontTalon1_r2", CubeListBuilder.create().texOffs(100, 24).addBox(0.4617f, -1.692f, -2.384f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)4.25f, (float)-0.75f, (float)0.7968f, (float)-0.268f, (float)-0.4031f));
        PartDefinition BackTalon_r2 = RightLegFoot.addOrReplaceChild("BackTalon_r2", CubeListBuilder.create().texOffs(98, 49).addBox(0.0f, -4.9526f, -2.7891f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition FrontFoot_r2 = RightLegFoot.addOrReplaceChild("FrontFoot_r2", CubeListBuilder.create().texOffs(96, 12).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-0.5f, (float)2.0f, (float)1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateState(AnimationDefinition definition, float value, float multiplies, boolean active) {
        if (active) {
            long movement = (long)(value * 30.0f * multiplies);
            KeyframeAnimations.animate((HierarchicalModel)this, (AnimationDefinition)definition, (long)movement, (float)1.0f, (Vector3f)this.ANIMATION_VECTOR_CACHE);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float movementValue = Mth.cos((float)(limbSwing * 0.6f)) * 0.6f * limbSwingAmount;
        float idleMovementValue = Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
        float headSpin = netHeadYaw / 57.295776f / 3.0f;
        if (!entity.onGround() && !entity.isInFluidType()) {
            this.animateState(ScavengerAnimations.FLIGHT, ageInTicks, 1.0f, !entity.onGround());
            this.leftLeg.xRot = idleMovementValue;
            this.rightLeg.xRot = -idleMovementValue;
        } else {
            this.leftLeg.xRot = movementValue;
            this.rightLeg.xRot = -movementValue;
            this.animateTentacleZ(this.rightWing, -1.3f - idleMovementValue);
            this.animateTentacleZ(this.leftWing, 1.3f + idleMovementValue);
        }
        this.animateTumor(this.Tumor1, Mth.cos((float)(ageInTicks / 7.0f)) / 7.0f);
        this.animateTumor(this.Tumor2, Mth.sin((float)(ageInTicks / 6.0f)) / 7.0f);
        this.animateTumor(this.Tumor3, Mth.sin((float)(ageInTicks / 7.0f)) / 6.0f);
        this.animateTumor(this.Tumor4, Mth.cos((float)(ageInTicks / 6.0f)) / 7.0f);
        this.animateTentacleX(this.tail1, Mth.cos((float)(ageInTicks / 7.0f)) / 5.0f);
        this.animateTentacleX(this.tail2, Mth.cos((float)(ageInTicks / 7.0f)) / 4.0f);
        this.animateTentacleX(this.tail3, Mth.cos((float)(ageInTicks / 8.0f)) / 5.0f);
        this.animateTentacleX(this.tail4, Mth.cos((float)(ageInTicks / 7.0f)) / 4.0f);
        this.animateTentacleX(this.tail5, Mth.cos((float)(ageInTicks / 6.0f)) / 5.0f);
        this.leftForLeg.xRot = this.leftLeg.xRot < 0.0f ? -this.leftLeg.xRot : 0.0f;
        this.rightForLeg.xRot = this.rightLeg.xRot < 0.0f ? -this.rightLeg.xRot : 0.0f;
        this.Neck1.zRot = headSpin;
        this.Neck2.zRot = headSpin;
        this.Head.zRot = headSpin;
        this.animateTentacleX(this.Jaw, -idleMovementValue);
        this.animateTentacleX(this.Fang1, idleMovementValue);
        this.animateTentacleX(this.Fang2, idleMovementValue);
        this.animateTentacleX(this.Fang3, -idleMovementValue);
        this.animateTentacleX(this.Fang4, -idleMovementValue);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.scavenger.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    public ModelPart root() {
        return this.scavenger;
    }
}

