/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.Harbinger.Spore.Sentities.FallenMultipart.SiegerTail;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SiegerTailModel<T extends SiegerTail>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"siegertailmodel"), "main");
    private final ModelPart gore;
    private final ModelPart tail5;
    private final ModelPart tail6;
    private final ModelPart tail7;
    private final ModelPart TumorBase3;
    private final ModelPart tail8;
    private final ModelPart tumor2;
    private final ModelPart TumorBase;
    private final ModelPart TumorBase2;

    public SiegerTailModel(ModelPart root) {
        this.gore = root.getChild("gore");
        this.tail5 = root.getChild("tail5");
        this.tail6 = this.tail5.getChild("tail6");
        this.tail7 = this.tail6.getChild("tail7");
        this.TumorBase3 = this.tail7.getChild("TumorBase3");
        this.tail8 = this.tail7.getChild("tail8");
        this.tumor2 = this.tail8.getChild("tumor2");
        this.TumorBase = this.tumor2.getChild("TumorBase");
        this.TumorBase2 = this.tumor2.getChild("TumorBase2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition gore = partdefinition.addOrReplaceChild("gore", CubeListBuilder.create().texOffs(0, 1).addBox(-1.0f, -2.0f, -15.0f, 2.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(2, 0).addBox(-4.0f, -3.0f, -14.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(11, 3).addBox(-1.0f, -5.0f, -13.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(12, 6).addBox(-3.0f, -5.0f, -12.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(12, 4).addBox(-5.0f, -2.0f, -13.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)21.0f, (float)-7.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tail5 = partdefinition.addOrReplaceChild("tail5", CubeListBuilder.create().texOffs(97, 0).addBox(-5.0f, -4.2201f, -27.863f, 10.0f, 10.0f, 27.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)20.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition tail6 = tail5.addOrReplaceChild("tail6", CubeListBuilder.create().texOffs(119, 206).addBox(-4.5f, -5.9163f, -0.0826f, 9.0f, 10.0f, 27.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-2.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition flower27 = tail6.addOrReplaceChild("flower27", CubeListBuilder.create().texOffs(152, 8).addBox(-3.5f, -3.0f, -2.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(92, 141).addBox(-3.5f, 3.0f, -3.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 206).addBox(-7.0f, -1.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)0.5f, (float)9.75f, (float)1.3687f, (float)-0.9903f, (float)-1.3305f));
        PartDefinition cube_r1 = flower27.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(205, 143).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.2182f, (float)0.0f));
        PartDefinition tail7 = tail6.addOrReplaceChild("tail7", CubeListBuilder.create().texOffs(191, 206).addBox(-4.0f, -4.9388f, 0.2976f, 8.0f, 10.0f, 27.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)26.0f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition TumorBase3 = tail7.addOrReplaceChild("TumorBase3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.8438f, (float)-2.7921f, (float)4.1882f, (float)0.0f, (float)0.0f, (float)2.9671f));
        PartDefinition Biomass_r1 = TumorBase3.addOrReplaceChild("Biomass_r1", CubeListBuilder.create().texOffs(134, 251).addBox(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9444f, (float)-0.6516f, (float)-4.1062f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Biomass_r2 = TumorBase3.addOrReplaceChild("Biomass_r2", CubeListBuilder.create().texOffs(136, 252).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8273f, (float)-0.3149f, (float)3.7818f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Biomass_r3 = TumorBase3.addOrReplaceChild("Biomass_r3", CubeListBuilder.create().texOffs(137, 254).addBox(3.0f, -3.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6309f, (float)1.1063f, (float)6.6738f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Biomass_r4 = TumorBase3.addOrReplaceChild("Biomass_r4", CubeListBuilder.create().texOffs(137, 253).addBox(-8.0f, -5.0f, 7.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5473f, (float)-4.3744f, (float)-11.2058f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition tail8 = tail7.addOrReplaceChild("tail8", CubeListBuilder.create().texOffs(55, 225).addBox(-3.5f, -6.6187f, 0.0213f, 7.0f, 10.0f, 27.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)27.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tumor2 = tail8.addOrReplaceChild("tumor2", CubeListBuilder.create().texOffs(123, 243).addBox(-8.0f, -9.6187f, 5.0213f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -8.6187f, -1.9787f, 12.0f, 14.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)26.0f, (float)1.4835f, (float)0.3491f, (float)0.0f));
        PartDefinition TumorBase = tumor2.addOrReplaceChild("TumorBase", CubeListBuilder.create(), PartPose.offset((float)2.1562f, (float)6.2079f, (float)8.1882f));
        PartDefinition Biomass_r5 = TumorBase.addOrReplaceChild("Biomass_r5", CubeListBuilder.create().texOffs(134, 251).addBox(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8989f, (float)-0.1307f, (float)0.8938f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Biomass_r6 = TumorBase.addOrReplaceChild("Biomass_r6", CubeListBuilder.create().texOffs(136, 252).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7817f, (float)0.206f, (float)8.7818f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Biomass_r7 = TumorBase.addOrReplaceChild("Biomass_r7", CubeListBuilder.create().texOffs(137, 254).addBox(3.0f, -3.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6765f, (float)1.6273f, (float)-4.3262f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Biomass_r8 = TumorBase.addOrReplaceChild("Biomass_r8", CubeListBuilder.create().texOffs(137, 253).addBox(-8.0f, -5.0f, 7.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5928f, (float)-3.8534f, (float)-6.2058f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition Biomass_r9 = TumorBase.addOrReplaceChild("Biomass_r9", CubeListBuilder.create().texOffs(132, 249).addBox(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0887f, (float)0.7284f, (float)-4.7513f, (float)-0.329f, (float)-1.0983f, (float)1.1961f));
        PartDefinition TumorBase2 = tumor2.addOrReplaceChild("TumorBase2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.1562f, (float)-4.7921f, (float)5.1882f, (float)0.0f, (float)0.0f, (float)2.9671f));
        PartDefinition Biomass_r10 = TumorBase2.addOrReplaceChild("Biomass_r10", CubeListBuilder.create().texOffs(134, 251).addBox(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8989f, (float)-0.1307f, (float)0.8938f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Biomass_r11 = TumorBase2.addOrReplaceChild("Biomass_r11", CubeListBuilder.create().texOffs(136, 252).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7817f, (float)0.206f, (float)8.7818f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Biomass_r12 = TumorBase2.addOrReplaceChild("Biomass_r12", CubeListBuilder.create().texOffs(137, 254).addBox(3.0f, -3.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6765f, (float)1.6273f, (float)-4.3262f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Biomass_r13 = TumorBase2.addOrReplaceChild("Biomass_r13", CubeListBuilder.create().texOffs(137, 253).addBox(-8.0f, -5.0f, 7.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5928f, (float)-3.8534f, (float)-6.2058f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition Biomass_r14 = TumorBase2.addOrReplaceChild("Biomass_r14", CubeListBuilder.create().texOffs(132, 249).addBox(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0887f, (float)0.7284f, (float)-4.7513f, (float)-0.329f, (float)-1.0983f, (float)1.1961f));
        PartDefinition flower28 = tail7.addOrReplaceChild("flower28", CubeListBuilder.create().texOffs(152, 8).addBox(-3.5f, -3.0f, -2.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(92, 141).addBox(-3.5f, 3.0f, -3.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 206).addBox(-7.0f, -1.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.5f, (float)9.75f, (float)1.3326f, (float)-0.1096f, (float)-0.4232f));
        PartDefinition cube_r2 = flower28.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(205, 143).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.2182f, (float)0.0f));
        PartDefinition flower29 = tail7.addOrReplaceChild("flower29", CubeListBuilder.create().texOffs(152, 8).addBox(-3.5f, -3.0f, -2.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(92, 141).addBox(-3.5f, 3.0f, -3.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 206).addBox(-7.0f, -1.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)5.5f, (float)14.75f, (float)1.3326f, (float)-0.1096f, (float)-0.4232f));
        PartDefinition cube_r3 = flower29.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(205, 143).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.2182f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    void animateGore(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 10.0f)) / 11.0f;
        part.yScale = 1.0f - Mth.cos((float)(value / 12.0f)) / 11.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 11.0f)) / 10.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateGore(this.gore, ageInTicks);
        this.animateTumor(this.TumorBase, Mth.sin((float)(ageInTicks / 7.0f)) / 6.0f);
        this.animateTumor(this.TumorBase2, Mth.cos((float)(ageInTicks / 6.0f)) / 9.0f);
        this.animateTumor(this.TumorBase3, -Mth.sin((float)(ageInTicks / 7.0f)) / 8.0f);
        this.animateTentacleX(this.tail6, Mth.sin((float)(ageInTicks / 15.0f)) / 15.0f);
        this.animateTentacleX(this.tail7, Mth.sin((float)(ageInTicks / 15.0f)) / 15.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.gore.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tail5.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

