/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Slasher;
import com.Harbinger.Spore.Sentities.Variants.SlasherVariants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SlasherModel<T extends Slasher>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"slashermodel"), "main");
    private final ModelPart body;
    private final ModelPart bodywear;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart HeadJoint;
    private final ModelPart Marm;

    public SlasherModel(ModelPart root) {
        this.body = root.getChild("body");
        this.bodywear = root.getChild("bodywear");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.HeadJoint = root.getChild("HeadJoint");
        this.Marm = root.getChild("Marm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(36, 21).addBox(-4.0f, 9.0f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(59, 41).addBox(0.5f, -3.75f, -2.0f, 4.0f, 3.75f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 75).addBox(-3.0f, -9.0f, -5.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-7, 87).addBox(-4.0f, -32.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(-7, 87).addBox(-1.0f, -33.0f, -12.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-7, 87).addBox(-3.0f, -29.0f, -6.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-0.1731f, (float)0.0227f, (float)0.1289f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-7, 87).addBox(-2.0f, -22.0f, 7.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r5 = body.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(-7, 87).addBox(-5.0f, -24.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r6 = body.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(18, 66).addBox(-16.0f, -32.0f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r7 = body.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(28, 47).addBox(-1.5f, 6.5f, -3.25f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-4.5f, -1.0f, -4.0f, 8.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(36, 12).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body_r2 = body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(0, 34).addBox(-6.0f, -11.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.1f)).texOffs(28, 34).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodywear = partdefinition.addOrReplaceChild("bodywear", CubeListBuilder.create().texOffs(75, 0).addBox(-4.0f, 0.0f, -3.25f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(62, 50).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r8 = LeftForArm.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(61, 18).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(32, 56).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(56, 30).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(16, 55).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(0, 55).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition HeadJoint = partdefinition.addOrReplaceChild("HeadJoint", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-3.0f, (float)0.0f));
        PartDefinition head = HeadJoint.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 0).addBox(-3.5f, -2.0f, -4.5f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(55, 0).addBox(-4.0f, -2.0f, 1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 1).addBox(-3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-0.5f, (float)0.1733f, (float)-0.0298f, (float)0.3438f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 47).addBox(-4.0f, -1.0f, -6.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition flower2 = HeadJoint.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)-6.5f, (float)-4.25f, (float)0.7039f, (float)-0.1949f, (float)-0.1078f));
        PartDefinition cube_r9 = flower2.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(-8, 87).addBox(0.0f, 0.0f, -3.84f, 7.68f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = flower2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(-8, 87).addBox(-7.68f, 0.0f, -3.84f, 7.68f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r11 = flower2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(-8, 87).addBox(-5.12f, 0.0f, -7.68f, 8.96f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.64f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = flower2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(-8, 87).addBox(-5.12f, 0.0f, 0.0f, 8.96f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.64f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower = HeadJoint.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-9.0f, (float)-2.0f, (float)0.162f, (float)0.1468f, (float)-0.7298f));
        PartDefinition cube_r13 = flower.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(-6, 87).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r14 = flower.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(-6, 87).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = flower.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(-6, 87).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Marm = partdefinition.addOrReplaceChild("Marm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-4.0f, (float)-2.0f));
        PartDefinition MarmJoint = Marm.addOrReplaceChild("MarmJoint", CubeListBuilder.create().texOffs(58, 8).addBox(-2.0f, -3.0f, -1.75f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(52, 47).addBox(-1.0f, -14.0f, -1.0f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition MArm2 = MarmJoint.addOrReplaceChild("MArm2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)1.0f));
        PartDefinition MarmJoint2 = MArm2.addOrReplaceChild("MarmJoint2", CubeListBuilder.create().texOffs(19, 19).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 13.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition claw = MarmJoint2.addOrReplaceChild("claw", CubeListBuilder.create().texOffs(0, 0).addBox(0.1f, -9.0f, -16.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-13.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Slasher)entity).attackAnim > 0.0f) {
            float f1 = -1.0f + Mth.abs((float)(10.0f - 2.0f * ((Slasher)entity).attackAnim)) / 6.5f;
            if (((Slasher)entity).getVariant() == SlasherVariants.PIERCER) {
                f1 = -1.0f + Mth.abs((float)(10.0f - 2.0f * ((Slasher)entity).attackAnim)) / 6.5f;
            }
            this.Marm.xRot = Mth.sin((float)f1) * 2.0f;
            this.Marm.getChild((String)"MarmJoint").getChild((String)"MArm2").xRot = -Mth.sin((float)f1) * 3.0f;
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
            this.LeftArm.zRot = 0.0f;
            this.Marm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.Marm.getChild((String)"MarmJoint").getChild((String)"MArm2").xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.Marm.getChild((String)"MarmJoint").getChild((String)"MArm2").getChild((String)"MarmJoint2").getChild((String)"claw").xRot = -Mth.sin((float)(ageInTicks / 6.0f)) / 8.0f;
        } else {
            this.Marm.xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 8.0f;
            this.Marm.getChild((String)"MarmJoint").getChild((String)"MArm2").xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.Marm.getChild((String)"MarmJoint").getChild((String)"MArm2").getChild((String)"MarmJoint2").getChild((String)"claw").xRot = -Mth.sin((float)(ageInTicks / 6.0f)) / 8.0f;
            this.LeftArm.zRot = -Mth.sin((float)(ageInTicks / 6.0f)) / 8.0f;
        }
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
        this.HeadJoint.getChild((String)"head").getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.bodywear.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.HeadJoint.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.Marm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

