/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Spitter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SpitterModel<T extends Spitter>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"spittermodel"), "main");
    private final ModelPart body;
    private final ModelPart bodywear;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart neck;
    private final ModelPart neckJoint;
    private final ModelPart neck2;
    private final ModelPart mutatedTube;
    private final ModelPart RightMandible;
    private final ModelPart LeftMandible;
    private final ModelPart RMJ;
    private final ModelPart RightMandible2;
    private final ModelPart LMJ;
    private final ModelPart LeftMandible2;
    private final ModelPart neckJoint2;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart leftForeleg;
    private final ModelPart rightForeleg;
    private static final float WALK_THRESHOLD = 0.15f;
    private static final float ARM_WALK_SPEED = 0.8f;
    private static final float LEG_WALK_SPEED = 0.8f;
    private static final float IDLE_ARM_SPEED = 0.125f;
    private static final float NECK_SWAY_SPEED = 0.125f;
    private static final float MANDIBLE_SPEED_1 = 0.2f;
    private static final float MANDIBLE_SPEED_2 = 0.25f;
    private static final float MANDIBLE_SPEED_3 = 0.166f;

    public SpitterModel(ModelPart root) {
        this.body = root.getChild("body");
        this.bodywear = root.getChild("bodywear");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.neck = root.getChild("neck");
        this.neckJoint = this.neck.getChild("neckJoint");
        this.neck2 = this.neckJoint.getChild("neck2");
        this.mutatedTube = this.neck.getChild("mutated_tube");
        this.RightMandible = this.neck2.getChild("RightMandible");
        this.LeftMandible = this.neck2.getChild("LeftMandible");
        this.RMJ = this.RightMandible.getChild("RMJ");
        this.RightMandible2 = this.RMJ.getChild("RightMandible2");
        this.LMJ = this.LeftMandible.getChild("LMJ");
        this.LeftMandible2 = this.LMJ.getChild("LeftMandible2");
        this.neckJoint2 = this.neck2.getChild("neckJoint2");
        this.head = this.neckJoint2.getChild("head");
        this.nose = this.head.getChild("nose");
        this.leftForeleg = this.LeftLeg.getChild("leftForLeg");
        this.rightForeleg = this.RightLeg.getChild("rightForLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 9.0f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(74, 1).addBox(-5.0f, -22.0f, -2.0f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0495f, (float)0.045f, (float)0.258f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(74, 1).addBox(-1.0f, -19.0f, -4.0f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-0.1687f, (float)-0.045f, (float)-0.258f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(72, 0).addBox(-6.0f, -22.0f, -7.0f, 6.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.5f, 2.75f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 10).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition body_r2 = body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(0, 48).addBox(0.0f, -7.0f, 3.0f, 0.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 25).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.25f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition bodywear = partdefinition.addOrReplaceChild("bodywear", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 9.0f, -3.25f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(44, 51).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)4.0f, (float)-3.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(55, 19).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = RightForArm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(48, 5).addBox(0.0f, 0.0f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition cube_r5 = RightForArm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(18, 53).addBox(0.0f, -2.0f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(32, 51).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)4.0f, (float)-3.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(55, 19).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r6 = LeftForArm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 13).addBox(0.5f, 0.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition cube_r7 = LeftForArm.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 29).addBox(0.5f, -2.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.1745f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(16, 45).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(44, 19).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 41).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(38, 40).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition neck = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)-3.0f));
        PartDefinition neckJoint = neck.addOrReplaceChild("neckJoint", CubeListBuilder.create().texOffs(23, 38).addBox(-2.5f, -2.0f, -3.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = neckJoint.addOrReplaceChild("neck2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.75f, (float)0.0f));
        PartDefinition neckJoint2 = neck2.addOrReplaceChild("neckJoint2", CubeListBuilder.create().texOffs(24, 0).addBox(-2.5f, -2.0f, -3.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckJoint2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(52, 36).addBox(-3.5f, -2.0f, -4.5f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -9.8f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.2f)).texOffs(62, 0).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 7.75f, 8.0f, new CubeDeformation(0.0f)).texOffs(28, 19).addBox(-4.0f, -2.0f, 1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 2).addBox(3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)-2.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = head.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(25, 61).addBox(-6.0f, -34.0f, -15.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)27.0f, (float)5.0f, (float)-0.2597f, (float)0.0338f, (float)0.1265f));
        PartDefinition cube_r9 = head.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(25, 61).addBox(-1.0f, -31.0f, -7.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)27.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r10 = head.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(72, 0).addBox(-8.0f, -31.0f, -4.0f, 6.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)27.0f, (float)5.0f, (float)0.0495f, (float)0.045f, (float)0.258f));
        PartDefinition cube_r11 = head.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(72, 0).addBox(-6.0f, -34.0f, -12.0f, 6.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)27.0f, (float)5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.25f, (float)-4.5f));
        PartDefinition cube_r12 = nose.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.1207f, -2.0141f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.25f, (float)-2.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = nose.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(2, 2).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)0.5f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = nose.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(0, 2).addBox(0.0f, -0.75f, -3.85f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)0.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = nose.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(4, 0).addBox(0.0f, 0.0f, -2.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = nose.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(2, 0).addBox(-0.5f, -1.0f, -3.75f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = nose.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(4, 2).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition RightMandible = neck2.addOrReplaceChild("RightMandible", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-0.25f, (float)-1.5f));
        PartDefinition RMJ = RightMandible.addOrReplaceChild("RMJ", CubeListBuilder.create().texOffs(11, 37).addBox(0.0f, -2.5f, -6.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 7).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.4363f, (float)0.0f));
        PartDefinition RightMandible2 = RMJ.addOrReplaceChild("RightMandible2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition RMJ2 = RightMandible2.addOrReplaceChild("RMJ2", CubeListBuilder.create().texOffs(11, 35).addBox(0.0f, -2.5f, -6.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)-0.3927f, (float)0.0f));
        PartDefinition LeftMandible = neck2.addOrReplaceChild("LeftMandible", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-0.25f, (float)-1.5f));
        PartDefinition LMJ = LeftMandible.addOrReplaceChild("LMJ", CubeListBuilder.create().texOffs(32, 2).addBox(0.0f, -2.5f, -6.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 32).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)-0.4363f, (float)0.0f));
        PartDefinition LeftMandible2 = LMJ.addOrReplaceChild("LeftMandible2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition LMJ2 = LeftMandible2.addOrReplaceChild("LMJ2", CubeListBuilder.create().texOffs(28, 17).addBox(0.0f, -2.5f, -6.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(38, 1).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.3927f, (float)0.0f));
        PartDefinition mutated_tube = neck.addOrReplaceChild("mutated_tube", CubeListBuilder.create().texOffs(54, 0).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition mutated_tube2 = mutated_tube.addOrReplaceChild("mutated_tube2", CubeListBuilder.create().texOffs(8, 54).addBox(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mutated_tube3 = mutated_tube2.addOrReplaceChild("mutated_tube3", CubeListBuilder.create().texOffs(53, 48).addBox(-1.5f, -1.5f, -2.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition mutated_tube4 = mutated_tube3.addOrReplaceChild("mutated_tube4", CubeListBuilder.create().texOffs(27, 45).addBox(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mutated_tube5 = mutated_tube4.addOrReplaceChild("mutated_tube5", CubeListBuilder.create().texOffs(52, 30).addBox(-1.5f, -1.5f, -2.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(49, 39).addBox(-3.0f, -3.0f, -2.55f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupArmAnimations(limbSwing, limbSwingAmount, ageInTicks);
        this.setupLegAnimations(limbSwing, limbSwingAmount);
        this.setupHeadAndNeckAnimations(netHeadYaw, headPitch, ageInTicks);
        this.setupMandibleAnimations(ageInTicks);
    }

    private void setupArmAnimations(float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (Math.abs(limbSwingAmount) > 0.15f) {
            float armMovement;
            this.RightArm.xRot = armMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = -armMovement;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
        } else {
            float idleSway;
            this.RightArm.zRot = idleSway = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
            this.LeftArm.zRot = -idleSway;
        }
    }

    private void setupLegAnimations(float limbSwing, float limbSwingAmount) {
        float legMovement;
        this.LeftLeg.xRot = legMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = -legMovement;
        this.updateForelegAnimations();
    }

    private void updateForelegAnimations() {
        if (this.LeftLeg.xRot < 0.0f) {
            this.leftForeleg.xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.rightForeleg.xRot = -this.RightLeg.xRot;
        }
    }

    private void setupHeadAndNeckAnimations(float netHeadYaw, float headPitch, float ageInTicks) {
        this.neck.yRot = netHeadYaw / 57.295776f;
        this.neck.xRot = headPitch / 28.647888f;
        this.neck2.xRot = Mth.sin((float)(ageInTicks * 0.125f)) * 0.125f;
        this.mutatedTube.xRot = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
        this.nose.xRot = 1.0f + Mth.sin((float)(ageInTicks * 0.125f)) * 0.125f;
    }

    private void setupMandibleAnimations(float ageInTicks) {
        this.setupPrimaryMandibleAnimations(ageInTicks);
        this.setupSecondaryMandibleAnimations(ageInTicks);
    }

    private void setupPrimaryMandibleAnimations(float ageInTicks) {
        float mandibleWave1 = Mth.sin((float)(ageInTicks * 0.2f));
        float mandibleWave2 = Mth.sin((float)(ageInTicks * 0.25f));
        this.RightMandible.xRot = mandibleWave1 * 0.25f;
        this.LeftMandible.xRot = mandibleWave1 * 0.166f;
        this.RightMandible.zRot = mandibleWave1 * 0.25f;
        this.LeftMandible.zRot = -mandibleWave2 * 0.2f;
    }

    private void setupSecondaryMandibleAnimations(float ageInTicks) {
        float mandibleWave3 = Mth.sin((float)(ageInTicks * 0.166f));
        float mandibleWave4 = Mth.sin((float)(ageInTicks * 0.2f));
        this.RightMandible2.xRot = mandibleWave3 * 0.2f;
        this.LeftMandible2.xRot = mandibleWave4 * 0.166f;
        this.RightMandible2.zRot = mandibleWave4 * 0.166f;
        this.LeftMandible2.zRot = -mandibleWave3 * 0.2f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.bodywear.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.neck.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

