/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Stalker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StalkerModel<T extends Stalker>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"stalkermodel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public StalkerModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 21).addBox(-3.4608f, -1.7037f, -4.9741f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-3.9608f, -9.7037f, -4.9741f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -9.7f, -5.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(4, 23).addBox(-3.0f, -10.7f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(61, 48).addBox(-3.9608f, -1.7037f, 1.0259f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 17).addBox(-3.9608f, -1.7037f, -4.9741f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(32, 19).addBox(4.0392f, -1.7037f, -3.9741f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)-0.75f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(26, 8).addBox(-6.5f, -33.0f, -5.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)26.3f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(11, 7).addBox(-4.0f, -37.0f, -5.25f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)26.3f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition fungus = head.addOrReplaceChild("fungus", CubeListBuilder.create().texOffs(-6, 75).addBox(-6.0f, -32.7f, -5.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)26.0f, (float)4.0f));
        PartDefinition cube_r3 = fungus.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-6, 75).addBox(5.75f, -30.75f, -3.5f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)0.0f, (float)0.228f, (float)0.1298f, (float)-0.3342f));
        PartDefinition cube_r4 = fungus.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-6, 75).addBox(-4.0f, -34.0f, -2.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r5 = fungus.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(-6, 75).addBox(-4.0f, -32.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r6 = fungus.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(-6, 75).addBox(-6.0f, -35.0f, -5.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 15).addBox(-0.9608f, -0.7037f, -5.9741f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(24, 15).addBox(-3.9608f, -0.7037f, -5.9741f, 8.0f, 2.0f, 6.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition flower = head.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-7.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r7 = flower.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(32, 93).addBox(-5.8388f, 0.253f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r8 = flower.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(14, 85).addBox(-3.9479f, 0.273f, -5.8869f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = flower.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(15, 78).addBox(-3.9479f, 0.273f, -0.1131f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = flower.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)2.0f, (float)0.2182f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = flower2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(70, 15).addBox(-0.2096f, 0.2061f, -4.06f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r11 = flower2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(88, 15).addBox(-8.0025f, 0.2939f, -4.06f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r12 = flower2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(88, 24).addBox(-5.1148f, 0.273f, -7.9519f, 9.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = flower2.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(18, 71).addBox(-0.2096f, 0.2061f, -3.06f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r14 = flower2.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(70, 23).addBox(-5.1148f, 0.227f, -0.159f, 9.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(29, 42).addBox(-4.25f, 10.05f, -1.5f, 8.5f, 3.0f, 4.75f, new CubeDeformation(0.0f)).texOffs(27, 25).addBox(-4.0f, 4.8f, -1.5f, 8.0f, 6.0f, 4.75f, new CubeDeformation(-0.1f)).texOffs(-6, 75).addBox(-3.0f, 8.3f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition cube_r15 = body.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(26, 8).addBox(-7.0f, -25.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)26.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(-6, 75).addBox(-6.0f, -1.7f, -4.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 75).addBox(-1.0f, 0.3f, -4.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 75).addBox(-6.0f, 2.3f, -4.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 75).addBox(-3.0f, -3.7f, -4.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 75).addBox(-1.0f, 3.3f, -2.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)4.75f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = spine2.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 2.75f, -9.25f, 10.0f, 8.0f, 7.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.7f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = spine2.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(4, 18).addBox(-3.0f, -19.0f, -20.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.3f, (float)-3.25f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r18 = spine2.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(-6, 75).addBox(-6.25f, -15.75f, 5.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.3f, (float)-3.25f, (float)0.5663f, (float)-0.0226f, (float)0.2588f));
        PartDefinition cube_r19 = spine2.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(-6, 75).addBox(1.75f, -21.75f, -1.5f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.3f, (float)-3.25f, (float)0.228f, (float)0.1298f, (float)-0.3342f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(28, 38).addBox(-2.0f, -1.7f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.75f, (float)-2.0f, (float)0.25f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(39, 2).addBox(-2.0f, 0.3f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(1, 66).addBox(-4.0f, 4.0f, 1.0f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(1, 66).addBox(-4.0f, 4.0f, -1.0f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(28, 38).addBox(-1.0f, -1.7f, -2.5f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.75f, (float)-2.0f, (float)0.75f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(46, 39).addBox(-1.0f, 0.3f, -2.75f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(46, 63).addBox(-1.0f, 4.0f, -1.5f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(46, 63).addBox(-1.0f, 4.0f, 0.5f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(28, 37).addBox(-2.75f, -0.7f, -1.75f, 3.75f, 7.0f, 3.75f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.4f, (float)11.75f, (float)0.75f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(1, 43).addBox(-2.75f, 0.3f, -1.75f, 3.75f, 6.0f, 3.75f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(46, 37).addBox(-1.0f, -0.7f, -1.75f, 3.75f, 7.0f, 3.75f, new CubeDeformation(0.0f)), PartPose.offset((float)1.4f, (float)11.75f, (float)0.75f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(60, 22).addBox(-1.0f, 0.3f, -1.75f, 3.75f, 6.0f, 3.75f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Stalker)entity).swinging) {
            this.LeftArm.xRot = this.RightArm.xRot = -89.5f + headPitch / 28.647888f;
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
            if (this.RightArm.xRot < 0.0f) {
                this.RightArm.getChild((String)"RightForArm").xRot = this.RightArm.xRot;
            }
            if (this.LeftArm.xRot < 0.0f) {
                this.LeftArm.getChild((String)"LeftForArm").xRot = this.LeftArm.xRot;
            }
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * -limbSwingAmount;
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        this.head.getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

