/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface TentacledModel {
    default public void animateTentacleX(ModelPart part, float value) {
        part.xRot = part.getInitialPose().xRot + value;
    }

    default public void animateTentacleY(ModelPart part, float value) {
        part.yRot = part.getInitialPose().yRot + value;
    }

    default public void animateTentacleZ(ModelPart part, float value) {
        part.zRot = part.getInitialPose().zRot + value;
    }

    default public void animateTumor(ModelPart part, float value) {
        part.xScale = 1.0f + value;
        part.yScale = 1.0f + value;
        part.zScale = 1.0f + value;
    }

    default public void matchLegToTerrain(ModelPart bone, LivingEntity entity, float reachDistance) {
        Vec3 start = entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        Vec3 end = start.subtract(0.0, (double)reachDistance, 0.0);
        BlockHitResult result = entity.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (result.getType() == HitResult.Type.BLOCK) {
            double distance = start.y - result.getLocation().y;
            bone.y = (float)(-distance);
        }
    }
}

