/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.ZoaholicBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ZoaholicModel<T extends ZoaholicBlockEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"zoaholic"), "main");
    private final ModelPart Base;
    private final ModelPart Blood;
    private final ModelPart Brain;
    private final ModelPart Heart;
    private final ModelPart InnardsTop;
    private final ModelPart InnardsDown;

    public ZoaholicModel() {
        ModelPart root = ZoaholicModel.createBodyLayer().bakeRoot();
        this.Base = root.getChild("Base");
        this.Blood = this.Base.getChild("GutBox").getChild("Blood");
        this.Brain = this.Base.getChild("Top").getChild("FrankenstineBrain");
        this.Heart = this.Base.getChild("GutBox").getChild("Heart");
        this.InnardsTop = this.Base.getChild("GutBox").getChild("Innards").getChild("HookedInnards");
        this.InnardsDown = this.Base.getChild("GutBox").getChild("Innards").getChild("LyingInnards");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Base = partdefinition.addOrReplaceChild("Base", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition GutBox = Base.addOrReplaceChild("GutBox", CubeListBuilder.create().texOffs(14, 59).addBox(-8.0f, -9.0f, -8.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 59).addBox(6.0f, -9.0f, -8.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 59).addBox(-8.0f, -9.0f, 6.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 59).addBox(6.0f, -9.0f, 6.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Glass = GutBox.addOrReplaceChild("Glass", CubeListBuilder.create().texOffs(0, 51).addBox(-6.0f, -10.0f, -7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-6.0f, -10.0f, 7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition WestPane_r1 = Glass.addOrReplaceChild("WestPane_r1", CubeListBuilder.create().texOffs(0, 51).addBox(-6.0f, -4.0f, -7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-6.0f, -4.0f, 7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition FleshHook = GutBox.addOrReplaceChild("FleshHook", CubeListBuilder.create().texOffs(29, 0).addBox(-0.5f, -0.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.25f)).texOffs(37, 0).addBox(-1.0f, 0.75f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.25f)).texOffs(39, 0).addBox(-1.0f, 2.25f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)).texOffs(27, 0).addBox(0.0f, 1.75f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-2.0f));
        PartDefinition Blood = GutBox.addOrReplaceChild("Blood", CubeListBuilder.create().texOffs(0, 36).addBox(-7.0f, -0.9f, -7.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Innards2 = GutBox.addOrReplaceChild("Innards", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition HookedInnards = Innards2.addOrReplaceChild("HookedInnards", CubeListBuilder.create(), PartPose.offset((float)1.4984f, (float)-3.2709f, (float)1.9307f));
        PartDefinition Seg_3_r1 = HookedInnards.addOrReplaceChild("Seg_3_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5834f, (float)0.6174f, (float)-0.4139f));
        PartDefinition Seg_4_r1 = HookedInnards.addOrReplaceChild("Seg_4_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.3278f, (float)0.62f, (float)1.361f, (float)0.0284f, (float)1.0183f, (float)0.087f));
        PartDefinition Seg_5_r1 = HookedInnards.addOrReplaceChild("Seg_5_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)3.0281f, (float)0.7113f, (float)2.4102f, (float)2.9551f, (float)0.8874f, (float)2.9774f));
        PartDefinition Seg_2_r1 = HookedInnards.addOrReplaceChild("Seg_2_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.5825f, (float)-1.9026f, (float)-0.2022f, (float)-1.4581f, (float)0.4523f, (float)-0.2477f));
        PartDefinition Seg_1_r1 = HookedInnards.addOrReplaceChild("Seg_1_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.9984f, (float)-3.4002f, (float)-1.4609f, (float)-0.8548f, (float)0.2878f, (float)-0.0288f));
        PartDefinition Seg2_r1 = HookedInnards.addOrReplaceChild("Seg2_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, 0.0f, -1.75f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.9984f, (float)-2.3057f, (float)-4.4679f, (float)1.3303f, (float)-0.18f, (float)0.3691f));
        PartDefinition Seg3_r1 = HookedInnards.addOrReplaceChild("Seg3_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-1.6348f, (float)-0.9948f, (float)-3.8053f, (float)2.0343f, (float)-0.0762f, (float)-0.013f));
        PartDefinition Seg1_r1 = HookedInnards.addOrReplaceChild("Seg1_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.9984f, (float)-3.2291f, (float)-1.9307f, (float)0.3123f, (float)-0.1586f, (float)0.4549f));
        PartDefinition Seg11_r1 = HookedInnards.addOrReplaceChild("Seg11_r1", CubeListBuilder.create().texOffs(0, 72).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-2.6869f, (float)0.6542f, (float)-0.6377f, (float)-0.1374f, (float)1.357f, (float)3.0113f));
        PartDefinition Seg10_r1 = HookedInnards.addOrReplaceChild("Seg10_r1", CubeListBuilder.create().texOffs(0, 72).addBox(-1.0f, -0.991f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-4.6155f, (float)0.6618f, (float)-1.1673f, (float)-3.0323f, (float)1.3012f, (float)0.1094f));
        PartDefinition Seg9_r1 = HookedInnards.addOrReplaceChild("Seg9_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-5.7728f, (float)0.6098f, (float)0.4631f, (float)-0.0356f, (float)0.6169f, (float)3.125f));
        PartDefinition Seg8_r1 = HookedInnards.addOrReplaceChild("Seg8_r1", CubeListBuilder.create().texOffs(0, 72).addBox(-1.75f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-6.0405f, (float)0.7577f, (float)2.112f, (float)0.0812f, (float)-0.2964f, (float)3.046f));
        PartDefinition Seg7_r1 = HookedInnards.addOrReplaceChild("Seg7_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -0.9929f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-3.0584f, (float)0.7238f, (float)2.4371f, (float)1.3463f, (float)-1.0624f, (float)1.7563f));
        PartDefinition Seg6_r1 = HookedInnards.addOrReplaceChild("Seg6_r1", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-1.9811f, (float)-0.1354f, (float)0.9875f, (float)2.5619f, (float)-0.523f, (float)0.2459f));
        PartDefinition Seg5_r1 = HookedInnards.addOrReplaceChild("Seg5_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -0.5f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-1.8307f, (float)0.062f, (float)-1.059f, (float)2.9948f, (float)-0.0702f, (float)-0.0323f));
        PartDefinition Seg4_r1 = HookedInnards.addOrReplaceChild("Seg4_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-1.6797f, (float)0.7949f, (float)-2.9137f, (float)-2.5029f, (float)-0.0702f, (float)-0.0323f));
        PartDefinition LyingInnards = Innards2.addOrReplaceChild("LyingInnards", CubeListBuilder.create(), PartPose.offset((float)0.5016f, (float)-3.2709f, (float)-1.9307f));
        PartDefinition Seg_4_r2 = LyingInnards.addOrReplaceChild("Seg_4_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-0.9801f, -0.9947f, -2.2964f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-2.7793f, (float)0.4447f, (float)9.6709f, (float)0.905f, (float)-1.2386f, (float)2.3447f));
        PartDefinition Seg_5_r2 = LyingInnards.addOrReplaceChild("Seg_5_r2", CubeListBuilder.create().texOffs(0, 72).addBox(-0.5934f, -0.4887f, -4.1735f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-2.6793f, (float)0.3447f, (float)9.6709f, (float)0.7518f, (float)-0.7288f, (float)2.148f));
        PartDefinition Seg_6_r1 = LyingInnards.addOrReplaceChild("Seg_6_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-6.1084f, (float)0.3287f, (float)8.2006f, (float)0.0125f, (float)-0.1431f, (float)2.4887f));
        PartDefinition Seg_3_r2 = LyingInnards.addOrReplaceChild("Seg_3_r2", CubeListBuilder.create().texOffs(0, 77).addBox(-0.9962f, -1.2445f, -2.1286f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.9187f, (float)0.4077f, (float)9.4251f, (float)2.4675f, (float)-1.2925f, (float)0.839f));
        PartDefinition Seg_2_r2 = LyingInnards.addOrReplaceChild("Seg_2_r2", CubeListBuilder.create().texOffs(0, 72).addBox(-1.0631f, -0.8006f, -2.3564f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.9901f, (float)0.8019f, (float)8.6715f, (float)2.5044f, (float)-1.1263f, (float)0.6803f));
        PartDefinition Seg3_r2 = LyingInnards.addOrReplaceChild("Seg3_r2", CubeListBuilder.create().texOffs(0, 77).addBox(-0.6236f, -1.5019f, -2.5307f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.4235f, (float)-1.1442f, (float)4.8427f, (float)2.4573f, (float)-0.0911f, (float)0.3991f));
        PartDefinition Seg4_r2 = LyingInnards.addOrReplaceChild("Seg4_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0589f, -0.3669f, -1.6928f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.6735f, (float)0.8558f, (float)3.8427f, (float)-2.5152f, (float)-0.0616f, (float)0.0467f));
        PartDefinition Seg2_r2 = LyingInnards.addOrReplaceChild("Seg2_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.1758f, -0.8696f, -2.3369f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.0941f, (float)0.787f, (float)6.7679f, (float)3.0641f, (float)0.0403f, (float)0.4784f));
        PartDefinition Seg12_r1 = LyingInnards.addOrReplaceChild("Seg12_r1", CubeListBuilder.create().texOffs(0, 72).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)2.4369f, (float)0.5042f, (float)0.8877f, (float)0.1374f, (float)1.357f, (float)-3.0113f));
        PartDefinition Seg11_r2 = LyingInnards.addOrReplaceChild("Seg11_r2", CubeListBuilder.create().texOffs(0, 72).addBox(-1.0f, -0.991f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)4.3655f, (float)0.5118f, (float)1.4173f, (float)3.0323f, (float)1.3012f, (float)-0.1094f));
        PartDefinition Seg10_r2 = LyingInnards.addOrReplaceChild("Seg10_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)5.5228f, (float)0.4598f, (float)-0.2131f, (float)0.0356f, (float)0.6169f, (float)-3.125f));
        PartDefinition Seg9_r2 = LyingInnards.addOrReplaceChild("Seg9_r2", CubeListBuilder.create().texOffs(0, 72).addBox(-0.25f, -1.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)5.7905f, (float)0.6077f, (float)-1.862f, (float)-0.0812f, (float)-0.2964f, (float)-3.046f));
        PartDefinition Seg8_r2 = LyingInnards.addOrReplaceChild("Seg8_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -0.9929f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)2.8084f, (float)0.5738f, (float)-2.1871f, (float)-1.3463f, (float)-1.0624f, (float)-1.7563f));
        PartDefinition Seg7_r2 = LyingInnards.addOrReplaceChild("Seg7_r2", CubeListBuilder.create().texOffs(0, 77).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.9811f, (float)-0.1354f, (float)-0.9875f, (float)-2.5619f, (float)-0.523f, (float)-0.2459f));
        PartDefinition Seg6_r2 = LyingInnards.addOrReplaceChild("Seg6_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.8307f, (float)0.062f, (float)1.059f, (float)-2.9948f, (float)-0.0702f, (float)0.0323f));
        PartDefinition Seg5_r2 = LyingInnards.addOrReplaceChild("Seg5_r2", CubeListBuilder.create().texOffs(0, 67).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.6797f, (float)0.7949f, (float)2.9137f, (float)2.5029f, (float)-0.0702f, (float)0.0323f));
        PartDefinition Heart = GutBox.addOrReplaceChild("Heart", CubeListBuilder.create().texOffs(16, 18).addBox(-2.0686f, 1.3444f, -1.2546f, 4.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-3.6212f, (float)-9.1045f, (float)-3.6818f, (float)-0.0042f, (float)-0.6541f, (float)0.0072f));
        PartDefinition FunnyLump_r1 = Heart.addOrReplaceChild("FunnyLump_r1", CubeListBuilder.create().texOffs(21, 21).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)1.1969f, (float)2.6233f, (float)0.2454f, (float)-0.829f, (float)-0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r2 = Heart.addOrReplaceChild("FunnyLump_r2", CubeListBuilder.create().texOffs(22, 20).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-1.234f, (float)2.8733f, (float)0.2454f, (float)0.829f, (float)-0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r3 = Heart.addOrReplaceChild("FunnyLump_r3", CubeListBuilder.create().texOffs(16, 18).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)-0.334f, (float)2.8733f, (float)-0.3546f, (float)-0.829f, (float)0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r4 = Heart.addOrReplaceChild("FunnyLump_r4", CubeListBuilder.create().texOffs(20, 21).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)-0.034f, (float)3.1233f, (float)0.7454f, (float)-0.829f, (float)0.7418f, (float)0.0f));
        PartDefinition TopRight_r1 = Heart.addOrReplaceChild("TopRight_r1", CubeListBuilder.create().texOffs(18, 18).addBox(-1.0f, -2.5f, -1.51f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-0.8186f, (float)2.5944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition BottomLeft_r1 = Heart.addOrReplaceChild("BottomLeft_r1", CubeListBuilder.create().texOffs(16, 18).addBox(-2.0f, -1.5f, -1.49f, 3.0f, 4.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.6814f, (float)3.5944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition Left_r1 = Heart.addOrReplaceChild("Left_r1", CubeListBuilder.create().texOffs(16, 18).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.4314f, (float)3.4444f, (float)-0.0046f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition Right_r1 = Heart.addOrReplaceChild("Right_r1", CubeListBuilder.create().texOffs(16, 18).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-0.3186f, (float)3.0944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition Top = Base.addOrReplaceChild("Top", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -12.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition ControlPanel = Top.addOrReplaceChild("ControlPanel", CubeListBuilder.create().texOffs(16, 0).addBox(-6.5f, -3.0f, 3.0f, 13.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 0).addBox(-6.5f, -2.0f, 1.0f, 13.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 0).addBox(-6.5f, -3.0f, 2.0f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(17, 0).addBox(-6.5f, -1.0f, 0.0f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-7.0f));
        PartDefinition Face = ControlPanel.addOrReplaceChild("Face", CubeListBuilder.create().texOffs(13, 12).addBox(-6.5f, -0.5f, 0.0f, 14.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0303f, (float)-0.5303f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Button2 = Face.addOrReplaceChild("Button", CubeListBuilder.create().texOffs(35, 65).addBox(-1.0f, -0.75f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.0f, (float)3.0f));
        PartDefinition ButtonFace = Button2.addOrReplaceChild("ButtonFace", CubeListBuilder.create().texOffs(76, 50).addBox(-0.5f, -1.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        PartDefinition Display = Face.addOrReplaceChild("Display", CubeListBuilder.create().texOffs(4, 12).addBox(-4.0f, -6.5f, -3.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(79, 12).addBox(-2.0f, -6.7f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(78, 77).addBox(-4.0f, -6.7f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(78, 70).addBox(-4.001f, -6.701f, -2.999f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).texOffs(48, 51).addBox(-4.001f, -6.701f, -0.999f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)8.5f, (float)5.4697f, (float)3.0303f));
        PartDefinition Needle = Display.addOrReplaceChild("Needle", CubeListBuilder.create().texOffs(9, 27).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)-2.5f, (float)-6.09f, (float)-2.35f));
        PartDefinition SmallButtons = Face.addOrReplaceChild("SmallButtons", CubeListBuilder.create().texOffs(48, 8).addBox(-1.625f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(48, 8).addBox(-0.625f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(48, 8).addBox(0.375f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(0, 59).addBox(-1.625f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(0, 59).addBox(-0.625f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(0, 59).addBox(0.375f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(38, 61).addBox(-1.625f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(38, 61).addBox(-0.625f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(38, 61).addBox(0.375f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)-0.875f, (float)-0.4874f, (float)3.1553f));
        PartDefinition Lever = Face.addOrReplaceChild("Lever", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)5.4697f, (float)2.5303f));
        PartDefinition Lever_r1 = Lever.addOrReplaceChild("Lever_r1", CubeListBuilder.create().texOffs(0, 9).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-5.8f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition LeverBase = Lever.addOrReplaceChild("LeverBase", CubeListBuilder.create().texOffs(30, 13).addBox(-2.0f, -14.5f, 6.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-4.0f, -14.5f, 6.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-3.0f, -14.5f, 6.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-3.0f, -14.5f, 9.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)8.0f, (float)-8.0f));
        PartDefinition Jar = Top.addOrReplaceChild("Jar", CubeListBuilder.create().texOffs(6, 51).addBox(-3.9f, -4.6f, -2.1f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(6, 51).addBox(-3.9f, -4.6f, 3.9f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(50, 47).addBox(-3.9f, -5.6f, -2.1f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.1f)).texOffs(42, 39).addBox(-0.4f, -6.6f, -1.6f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(11, 9).addBox(1.1f, -6.85f, -1.1f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.09f)), PartPose.offset((float)-3.6f, (float)-10.9f, (float)3.6f));
        PartDefinition GlassWest_r1 = Jar.addOrReplaceChild("GlassWest_r1", CubeListBuilder.create().texOffs(6, 51).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(6, 51).addBox(-3.0f, -2.0f, 3.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.9f, (float)-2.6f, (float)0.9f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition BrainSmall = Jar.addOrReplaceChild("BrainSmall", CubeListBuilder.create().texOffs(1, 19).addBox(-2.8027f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)).texOffs(1, 19).addBox(0.1973f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)).texOffs(1, 1).addBox(-1.3027f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5973f, (float)-1.2088f, (float)-0.164f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Formaldehyde = Jar.addOrReplaceChild("Formaldehyde", CubeListBuilder.create().texOffs(48, 4).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-0.9f, (float)-0.5f, (float)0.9f));
        PartDefinition JarToControlWires = Top.addOrReplaceChild("JarToControlWires", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Wire1 = JarToControlWires.addOrReplaceChild("Wire1", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, -0.75f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(36, 59).addBox(-4.0f, -0.75f, 2.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 18).addBox(-4.0f, -4.75f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-4.0f, -4.75f, 3.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)-2.0f));
        PartDefinition Wire2 = JarToControlWires.addOrReplaceChild("Wire2", CubeListBuilder.create().texOffs(78, 72).addBox(-0.25f, -0.5f, -0.1f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)).texOffs(10, 0).addBox(-0.25f, -3.5f, 2.7f, 1.0f, 4.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(0, 2).addBox(-0.25f, -3.5f, 3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)).texOffs(48, 4).addBox(-2.05f, -3.5f, 4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-0.25f, (float)-14.25f, (float)-2.0f));
        PartDefinition FrankenstineBrain = Top.addOrReplaceChild("FrankenstineBrain", CubeListBuilder.create(), PartPose.offset((float)5.75f, (float)-15.75f, (float)-2.5f));
        PartDefinition MetalRod3Top_r1 = FrankenstineBrain.addOrReplaceChild("MetalRod3Top_r1", CubeListBuilder.create().texOffs(77, 58).addBox(-1.0023f, -3.7672f, 6.0306f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)).texOffs(12, 30).addBox(-0.5023f, -3.2672f, 6.5306f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2597f, (float)0.0338f, (float)0.1265f));
        PartDefinition MetalRod2Top_r1 = FrankenstineBrain.addOrReplaceChild("MetalRod2Top_r1", CubeListBuilder.create().texOffs(77, 58).addBox(-1.0023f, -1.7672f, -2.0306f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(12, 30).addBox(-0.5023f, -1.5172f, -1.5306f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.0f, (float)0.2597f, (float)-0.0338f, (float)0.1265f));
        PartDefinition MetalRod1Top_r1 = FrankenstineBrain.addOrReplaceChild("MetalRod1Top_r1", CubeListBuilder.create().texOffs(77, 58).addBox(-1.0f, -3.75f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).texOffs(12, 30).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)1.7f, (float)6.0f, (float)0.1745f, (float)0.0f, (float)-0.3491f));
        PartDefinition BrainLarge = FrankenstineBrain.addOrReplaceChild("BrainLarge", CubeListBuilder.create().texOffs(0, 18).addBox(-2.75f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.2f)).texOffs(0, 18).addBox(0.75f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.2f)).texOffs(0, 0).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.5f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateHeart(boolean isActive, boolean hasHeart, ModelPart heart, float value) {
        if (hasHeart) {
            heart.visible = true;
            if (isActive) {
                heart.xScale = 1.0f + Mth.sin((float)(value / 4.0f)) / 6.0f;
                heart.zScale = 1.0f + Mth.sin((float)(value / 4.0f)) / 6.0f;
                heart.yScale = 1.0f + Mth.cos((float)(value / 4.0f)) / 6.0f;
            } else {
                heart.resetPose();
            }
        } else {
            heart.visible = false;
        }
    }

    private void animateBrain(boolean isActive, boolean hasBrain, float value) {
        if (hasBrain) {
            this.Brain.visible = true;
            if (isActive) {
                this.Brain.getChild((String)"BrainLarge").xScale = 1.0f + Mth.sin((float)(value / 6.0f)) / 6.0f;
                this.Brain.getChild((String)"BrainLarge").zScale = 1.0f + Mth.sin((float)(value / 6.0f)) / 6.0f;
                this.Brain.getChild((String)"BrainLarge").yScale = 1.0f + Mth.sin((float)(value / 6.0f)) / 6.0f;
            } else {
                this.Brain.getChild("BrainLarge").resetPose();
            }
        } else {
            this.Brain.visible = false;
        }
    }

    private void animateBlood(boolean isActive, boolean biomass, ModelPart blood, float value) {
        if (biomass) {
            blood.visible = true;
            if (isActive) {
                blood.yScale = 1.0f + Mth.sin((float)(value / 5.0f)) / 2.0f;
            } else {
                blood.resetPose();
            }
        } else {
            blood.visible = false;
        }
    }

    private void animateInnards(boolean isActive, boolean innard, ModelPart innards, float value) {
        if (innard) {
            innards.visible = true;
            if (isActive) {
                innards.xScale = 1.0f + Mth.sin((float)(value / 7.0f)) / 10.0f;
                innards.zScale = 1.0f + Mth.sin((float)(value / 8.0f)) / 10.0f;
                innards.yScale = 1.0f + Mth.sin((float)(value / 6.0f)) / 10.0f;
            } else {
                innards.resetPose();
            }
        } else {
            innards.visible = false;
        }
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.animateBrain(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).HasBrain(), ageInTicks);
        this.animateBlood(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getBiomass() > 0, this.Blood, ageInTicks);
        this.animateHeart(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).HasHeart(), this.Heart, ageInTicks);
        this.animateInnards(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getAmountOfInnards() > 0, this.InnardsTop, ageInTicks);
        this.animateInnards(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getAmountOfInnards() > 1, this.InnardsDown, -ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.Base.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

