/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class fleshArmorModel<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"flesharmormodel"), "main");
    public final ModelPart headwear;
    public final ModelPart tendril;
    public final ModelPart body;
    public final ModelPart heart;
    public final ModelPart rightLung;
    public final ModelPart leftLung;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart leftBoot;
    public final ModelPart rightBoot;
    public final ModelPart pelvis;

    public fleshArmorModel() {
        ModelPart root = fleshArmorModel.createBodyLayer().bakeRoot();
        this.headwear = root.getChild("headwear");
        this.tendril = this.headwear.getChild("tendril");
        this.body = root.getChild("body");
        this.heart = this.body.getChild("heart");
        this.rightLung = this.body.getChild("rightLung");
        this.leftLung = this.body.getChild("leftLung");
        this.rightArm = root.getChild("rightArm");
        this.leftArm = root.getChild("leftArm");
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
        this.leftBoot = root.getChild("leftBoot");
        this.rightBoot = root.getChild("rightBoot");
        this.pelvis = root.getChild("pelvis");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition headwear = partdefinition.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition brain_r1 = headwear.addOrReplaceChild("brain_r1", CubeListBuilder.create().texOffs(50, 0).addBox(-3.0f, -4.0f, 0.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril = headwear.addOrReplaceChild("tendril", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-2.0f, (float)7.0f));
        PartDefinition cube_r1 = tendril.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(50, 36).addBox(1.0f, -1.9281f, -1.611f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.6f, (float)0.0f, (float)0.3927f, (float)0.4363f, (float)0.0f));
        PartDefinition cube_r2 = tendril.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(50, 36).addBox(1.0f, -1.9281f, -1.611f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.6f, (float)-1.0f, (float)0.3927f, (float)-0.4363f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.01f)).texOffs(0, 31).addBox(0.0f, -1.0f, 2.75f, 0.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(32, 20).mirror().addBox(-1.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(32, 20).addBox(-2.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition heart = body.addOrReplaceChild("heart", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.1f, (float)3.8f, (float)-2.05f, (float)-0.0263f, (float)-0.0832f, (float)0.3065f));
        PartDefinition body_r1 = heart.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(18, 60).addBox(-0.8381f, -0.5587f, -0.95f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)-0.0752f, (float)-0.8348f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r2 = heart.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(57, 20).addBox(0.8381f, -0.9413f, -1.05f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-1.2273f, (float)-0.5898f, (float)-0.35f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r3 = heart.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(36, 56).addBox(-2.1619f, -2.9413f, -1.05f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.8f)), PartPose.offsetAndRotation((float)-0.8252f, (float)0.4152f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition rightLung = body.addOrReplaceChild("rightLung", CubeListBuilder.create().texOffs(6, 58).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(12, 59).addBox(-1.5f, 0.5f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)3.5f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.1745f));
        PartDefinition leftLung = body.addOrReplaceChild("leftLung", CubeListBuilder.create().texOffs(12, 59).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(6, 58).addBox(-0.5f, 0.5f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.15f, (float)3.5f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)-0.1745f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r5 = rightArm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(60, 55).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-2.0f, (float)-2.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r6 = rightArm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(60, 55).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(16, 32).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).texOffs(60, 55).addBox(3.0f, -4.0f, -1.5f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(60, 55).addBox(3.0f, -4.0f, 1.5f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(32, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(24, 25).addBox(-0.2f, 1.0f, -3.25f, 0.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(24, 25).addBox(0.0f, 1.0f, -3.25f, 0.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftBoot = partdefinition.addOrReplaceChild("leftBoot", CubeListBuilder.create().texOffs(32, 43).addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightBoot = partdefinition.addOrReplaceChild("rightBoot", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition pelvis = partdefinition.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private void animateHeart(float age) {
        float val = Mth.sin((float)(age / 6.0f)) / 6.0f;
        this.heart.xScale = 1.0f + val;
        this.heart.zScale = 1.0f + val;
        this.heart.yScale = 1.0f - val;
    }

    private void animateLung(ModelPart part, float age) {
        float val = Mth.sin((float)(age / 8.0f)) / 4.0f;
        part.xScale = 1.0f + val;
        part.yScale = 1.0f - val;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateHeart(ageInTicks);
        this.animateLung(this.leftLung, ageInTicks);
        this.animateLung(this.rightLung, ageInTicks);
        this.tendril.xRot = Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.headwear.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pelvis.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

