/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class livingArmorMkModel<T extends LivingEntity>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"livingarmormkmodel"), "main");
    public final ModelPart headwear;
    private final ModelPart pupil;
    private final ModelPart breathing_aparatus;
    private final ModelPart breathing_aparatus2;
    private final ModelPart brain;
    private final ModelPart lob1;
    private final ModelPart lob2;
    public final ModelPart body;
    private final ModelPart spine;
    private final ModelPart heart;
    private final ModelPart leftJoint;
    private final ModelPart left_wing;
    private final ModelPart left_for_wing;
    private final ModelPart rightJoint;
    private final ModelPart right_wing;
    private final ModelPart right_for_wing;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart pelvis;
    public final ModelPart leftBoot;
    public final ModelPart rightBoot;

    public livingArmorMkModel() {
        ModelPart root = livingArmorMkModel.createBodyLayer().bakeRoot();
        this.headwear = root.getChild("headwear");
        this.pupil = this.headwear.getChild("pupil");
        this.breathing_aparatus = this.headwear.getChild("breathing_aparatus");
        this.breathing_aparatus2 = this.headwear.getChild("breathing_aparatus2");
        this.brain = this.headwear.getChild("brain");
        this.lob1 = this.brain.getChild("lob1");
        this.lob2 = this.brain.getChild("lob2");
        this.body = root.getChild("body");
        this.spine = this.body.getChild("spine");
        this.heart = this.body.getChild("heart");
        this.leftJoint = this.body.getChild("leftJoint");
        this.left_wing = this.leftJoint.getChild("left_wing");
        this.left_for_wing = this.left_wing.getChild("left_for_wing");
        this.rightJoint = this.body.getChild("rightJoint");
        this.right_wing = this.rightJoint.getChild("right_wing");
        this.right_for_wing = this.right_wing.getChild("right_for_wing");
        this.rightArm = root.getChild("rightArm");
        this.leftArm = root.getChild("leftArm");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
        this.pelvis = root.getChild("pelvis");
        this.leftBoot = root.getChild("leftBoot");
        this.rightBoot = root.getChild("rightBoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition headwear = partdefinition.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.2f)).texOffs(96, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)).texOffs(32, 6).addBox(-1.0f, -9.0f, -4.0f, 2.0f, 1.0f, 8.0f, new CubeDeformation(1.0f)).texOffs(27, -12).addBox(0.0f, -12.0f, -6.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(64, -8).addBox(-3.0f, -10.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(64, -8).addBox(3.0f, -10.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(110, 57).addBox(-4.0f, -8.0f, -6.0f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pupil = headwear.addOrReplaceChild("pupil", CubeListBuilder.create().texOffs(101, 58).addBox(-1.5f, -1.5f, -0.55f, 3.0f, 4.0f, 1.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-6.0f));
        PartDefinition breathing_aparatus = headwear.addOrReplaceChild("breathing_aparatus", CubeListBuilder.create().texOffs(84, 51).addBox(-2.25f, -3.75f, 1.25f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)-5.0f));
        PartDefinition Plane_r1 = breathing_aparatus.addOrReplaceChild("Plane_r1", CubeListBuilder.create().texOffs(88, 57).addBox(-4.0f, -3.5f, 0.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.75f, (float)-3.3567f, (float)4.776f, (float)-1.4193f, (float)0.0869f, (float)-0.517f));
        PartDefinition cube_r1 = breathing_aparatus.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(85, 52).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-1.25f, (float)-2.75f, (float)4.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = breathing_aparatus.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(84, 46).addBox(-1.0f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)-1.5f, (float)-0.25f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = breathing_aparatus.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(91, 46).addBox(-1.0f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.75f, (float)-0.75f, (float)0.25f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        PartDefinition breathing_aparatus2 = headwear.addOrReplaceChild("breathing_aparatus2", CubeListBuilder.create().texOffs(84, 51).mirror().addBox(0.25f, -3.75f, 1.25f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)0.0f, (float)-5.0f));
        PartDefinition Plane_r2 = breathing_aparatus2.addOrReplaceChild("Plane_r2", CubeListBuilder.create().texOffs(88, 57).mirror().addBox(0.0f, -3.5f, 0.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.75f, (float)-3.3567f, (float)4.776f, (float)-1.4193f, (float)-0.0869f, (float)0.517f));
        PartDefinition cube_r4 = breathing_aparatus2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(85, 52).mirror().addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)1.25f, (float)-2.75f, (float)4.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = breathing_aparatus2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(84, 46).mirror().addBox(0.0f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-1.5f, (float)-0.25f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = breathing_aparatus2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(91, 46).mirror().addBox(0.0f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.75f, (float)-0.75f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.8727f));
        PartDefinition brain = headwear.addOrReplaceChild("brain", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition cube_r7 = brain.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(77, 2).mirror().addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r8 = brain.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(77, 2).addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.75f, (float)0.75f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = brain.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(77, 2).mirror().addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.5f, (float)-7.0f, (float)2.0f, (float)1.7453f, (float)0.0f, (float)-1.0472f));
        PartDefinition cube_r10 = brain.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(77, 2).addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-7.0f, (float)2.0f, (float)1.7453f, (float)0.0f, (float)1.0472f));
        PartDefinition cube_r11 = brain.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(77, 2).addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition cube_r12 = brain.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(73, 0).addBox(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition lob1 = brain.addOrReplaceChild("lob1", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-6.0f, (float)0.0f));
        PartDefinition cube_r13 = lob1.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(83, 0).addBox(-3.0f, -4.0f, -1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.75f, (float)2.0f, (float)-1.25f, (float)-0.0814f, (float)0.2947f, (float)-0.2739f));
        PartDefinition lob2 = brain.addOrReplaceChild("lob2", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-6.0f, (float)0.0f));
        PartDefinition cube_r14 = lob2.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(83, 0).mirror().addBox(-1.0f, -4.0f, -1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(-0.1f)).mirror(false), PartPose.offsetAndRotation((float)-0.75f, (float)2.0f, (float)-1.25f, (float)-0.0814f, (float)-0.2947f, (float)0.2739f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.15f)).texOffs(104, 22).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = body.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(110, 43).mirror().addBox(-1.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition cube_r16 = body.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(120, 43).addBox(-2.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.2f, (float)0.0f));
        PartDefinition cube_r17 = spine.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(62, 38).addBox(-1.0f, -0.2294f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.24f)), PartPose.offsetAndRotation((float)0.0f, (float)9.166f, (float)3.3f, (float)-1.3852f, (float)0.0095f, (float)0.0174f));
        PartDefinition cube_r18 = spine.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(60, 19).addBox(-1.0f, -0.2294f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)8.032f, (float)3.0f, (float)-1.7279f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = spine.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -0.2294f, -3.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.23f)), PartPose.offsetAndRotation((float)0.0f, (float)11.536f, (float)2.4f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = spine.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(62, 44).addBox(-1.0f, -0.6287f, -1.5094f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.23f)), PartPose.offsetAndRotation((float)0.0f, (float)3.418f, (float)2.85f, (float)-1.3788f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r21 = spine.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(62, 41).addBox(-1.0f, 0.4781f, -2.8277f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)3.218f, (float)4.0f, (float)-1.3439f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = spine.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(52, 39).addBox(-1.0f, -2.06f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.24f)), PartPose.offsetAndRotation((float)0.0f, (float)6.584f, (float)1.65f, (float)-1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition heart = body.addOrReplaceChild("heart", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.1f, (float)3.8f, (float)-2.55f, (float)-0.1572f, (float)-0.0832f, (float)0.3065f));
        PartDefinition body_r1 = heart.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(118, 40).addBox(-0.8381f, -0.5587f, -0.95f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)-0.0752f, (float)-0.8348f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r2 = heart.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(122, 38).addBox(0.8381f, -0.9413f, -1.05f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-1.2273f, (float)-0.5898f, (float)-0.35f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r3 = heart.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(112, 38).addBox(-2.1619f, -2.9413f, -1.05f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.8f)), PartPose.offsetAndRotation((float)-0.8252f, (float)0.4152f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition leftJoint = body.addOrReplaceChild("leftJoint", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-5.0f, (float)-3.0f, (float)3.75f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = leftJoint.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 78).addBox(-7.25f, -1.0f, -1.0f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)-2.7925f));
        PartDefinition left_for_wing = left_wing.addOrReplaceChild("left_for_wing", CubeListBuilder.create().texOffs(17, 108).addBox(-12.25f, -7.0f, 0.01f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)12.0f, (float)-1.0f));
        PartDefinition rightJoint = body.addOrReplaceChild("rightJoint", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.0f, (float)-3.0f, (float)3.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = rightJoint.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 93).addBox(-9.75f, -1.0f, -0.95f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)-6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)2.7925f));
        PartDefinition right_for_wing = right_wing.addOrReplaceChild("right_for_wing", CubeListBuilder.create().texOffs(0, 108).addBox(-4.25f, -7.0f, 0.06f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)12.0f, (float)-1.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(24, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(88, 22).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r23 = rightArm.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(30, 62).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)10.0f, (float)0.8f, (float)0.0f, (float)1.5708f, (float)-3.1416f));
        PartDefinition cube_r24 = rightArm.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(62, 30).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)10.0f, (float)-1.2f, (float)0.0f, (float)1.5708f, (float)-3.1416f));
        PartDefinition right_arm_r1 = rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(14, 50).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition right_arm_r2 = rightArm.addOrReplaceChild("right_arm_r2", CubeListBuilder.create().texOffs(58, 60).addBox(-4.0f, -11.0f, -1.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.6f, (float)2.3f, (float)0.0f, (float)0.0f, (float)-0.3752f));
        PartDefinition right_arm_r3 = rightArm.addOrReplaceChild("right_arm_r3", CubeListBuilder.create().texOffs(50, 60).addBox(-4.0f, -11.0f, -1.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)3.0f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0262f));
        PartDefinition right_arm_r4 = rightArm.addOrReplaceChild("right_arm_r4", CubeListBuilder.create().texOffs(32, 43).addBox(-4.0f, -12.0f, -1.0f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)1.2f, (float)-0.8f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition right_arm_r5 = rightArm.addOrReplaceChild("right_arm_r5", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -11.0f, -1.0f, 7.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(72, 22).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r25 = leftArm.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(24, 56).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)10.0f, (float)-1.2f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition cube_r26 = leftArm.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(62, 5).addBox(0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9f, (float)10.0f, (float)0.8f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition left_arm_r1 = leftArm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(16, 32).addBox(0.2f, 0.0f, -3.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.4f)), PartPose.offsetAndRotation((float)4.8f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.2654f));
        PartDefinition left_arm_r2 = leftArm.addOrReplaceChild("left_arm_r2", CubeListBuilder.create().texOffs(40, 15).addBox(-1.8f, -4.0f, -3.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(88, 35).mirror().addBox(-2.1f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)).mirror(false).texOffs(72, 46).mirror().addBox(-1.5f, -2.0f, -3.0f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r27 = leftLeg.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(72, 46).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.75f, (float)0.25f, (float)2.75f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r28 = leftLeg.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(72, 45).mirror().addBox(-1.0f, -2.0f, -2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.75f, (float)0.25f, (float)2.75f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r29 = leftLeg.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(0, 64).mirror().addBox(-0.15f, -2.0f, -1.0f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)-4.25f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r30 = leftLeg.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(40, 60).mirror().addBox(-3.9f, 1.75f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.61f)).mirror(false), PartPose.offsetAndRotation((float)1.75f, (float)0.5f, (float)-3.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r31 = leftLeg.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(52, 6).mirror().addBox(-4.0f, -0.25f, -1.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.6f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-0.5f, (float)4.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r32 = leftLeg.addOrReplaceChild("cube_r32", CubeListBuilder.create().texOffs(16, 43).mirror().addBox(0.9f, 2.0f, -2.0f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.6f, (float)1.0f, (float)-0.5f, (float)0.0f, (float)0.0436f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(88, 35).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(72, 46).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r33 = rightLeg.addOrReplaceChild("cube_r33", CubeListBuilder.create().texOffs(72, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.75f, (float)0.25f, (float)2.75f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r34 = rightLeg.addOrReplaceChild("cube_r34", CubeListBuilder.create().texOffs(72, 45).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.75f, (float)0.25f, (float)2.75f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r35 = rightLeg.addOrReplaceChild("cube_r35", CubeListBuilder.create().texOffs(0, 64).addBox(0.15f, -2.0f, -1.0f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)-4.25f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r36 = rightLeg.addOrReplaceChild("cube_r36", CubeListBuilder.create().texOffs(60, 14).addBox(-0.1f, 1.75f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)-1.75f, (float)0.5f, (float)-3.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r37 = rightLeg.addOrReplaceChild("cube_r37", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -0.25f, -1.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)-2.0f, (float)-0.5f, (float)4.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r38 = rightLeg.addOrReplaceChild("cube_r38", CubeListBuilder.create().texOffs(16, 43).addBox(-0.9f, 2.0f, -2.0f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6f, (float)1.0f, (float)-0.5f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        PartDefinition pelvis = partdefinition.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(104, 32).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftBoot = partdefinition.addOrReplaceChild("leftBoot", CubeListBuilder.create().texOffs(46, 43).addBox(-1.9f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(112, 48).addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r39 = leftBoot.addOrReplaceChild("cube_r39", CubeListBuilder.create().texOffs(92, 63).addBox(0.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.75f, (float)9.0f, (float)0.5f, (float)-0.2153f, (float)-0.8008f, (float)0.0554f));
        PartDefinition cube_r40 = leftBoot.addOrReplaceChild("cube_r40", CubeListBuilder.create().texOffs(92, 68).addBox(0.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.75f, (float)11.0f, (float)0.5f, (float)-0.8249f, (float)-1.0228f, (float)0.7459f));
        PartDefinition cube_r41 = leftBoot.addOrReplaceChild("cube_r41", CubeListBuilder.create().texOffs(72, 57).addBox(-1.0f, -2.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)9.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r42 = leftBoot.addOrReplaceChild("cube_r42", CubeListBuilder.create().texOffs(56, 49).addBox(0.0f, -5.0f, -1.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r43 = leftBoot.addOrReplaceChild("cube_r43", CubeListBuilder.create().texOffs(30, 52).addBox(-0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.2f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)-0.2618f, (float)0.0f));
        PartDefinition cube_r44 = leftBoot.addOrReplaceChild("cube_r44", CubeListBuilder.create().texOffs(46, 50).addBox(0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)0.2618f, (float)0.0f));
        PartDefinition rightBoot = partdefinition.addOrReplaceChild("rightBoot", CubeListBuilder.create().texOffs(40, 22).addBox(-1.9f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.12f)).texOffs(96, 48).addBox(-1.8f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.99f)), PartPose.offset((float)-2.1f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r45 = rightBoot.addOrReplaceChild("cube_r45", CubeListBuilder.create().texOffs(72, 57).mirror().addBox(0.0f, -2.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.8f, (float)9.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r46 = rightBoot.addOrReplaceChild("cube_r46", CubeListBuilder.create().texOffs(92, 68).mirror().addBox(-3.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.55f, (float)11.0f, (float)0.5f, (float)-0.8249f, (float)1.0228f, (float)-0.7459f));
        PartDefinition cube_r47 = rightBoot.addOrReplaceChild("cube_r47", CubeListBuilder.create().texOffs(92, 63).mirror().addBox(-3.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.55f, (float)9.0f, (float)0.5f, (float)-0.2153f, (float)0.8008f, (float)-0.0554f));
        PartDefinition cube_r48 = rightBoot.addOrReplaceChild("cube_r48", CubeListBuilder.create().texOffs(56, 19).addBox(0.0f, -5.0f, -1.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r49 = rightBoot.addOrReplaceChild("cube_r49", CubeListBuilder.create().texOffs(14, 54).addBox(-0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)-0.2618f, (float)0.0f));
        PartDefinition cube_r50 = rightBoot.addOrReplaceChild("cube_r50", CubeListBuilder.create().texOffs(52, 29).addBox(0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)0.2618f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void animatedElytra(T entity, ModelPart rightWing, ModelPart leftWing) {
        float f = 0.2617994f;
        float f1 = -0.2617994f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (entity.isFallFlying()) {
            float f4 = 1.0f;
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec31 = vec3.normalize();
                f4 = 1.0f - (float)Math.pow(-vec31.y, 1.5);
            }
            f = f4 * 0.34906584f + (1.0f - f4) * f;
            f1 = f4 * -1.5707964f + (1.0f - f4) * f1;
        } else if (entity.isCrouching()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 3.0f;
            f3 = 0.08726646f;
        }
        leftWing.y = f2;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            abstractclientplayer.elytraRotX += (f - abstractclientplayer.elytraRotX) * 0.1f;
            abstractclientplayer.elytraRotY += (f3 - abstractclientplayer.elytraRotY) * 0.1f;
            abstractclientplayer.elytraRotZ += (f1 - abstractclientplayer.elytraRotZ) * 0.1f;
            leftWing.xRot = abstractclientplayer.elytraRotX;
            leftWing.yRot = abstractclientplayer.elytraRotY;
            leftWing.zRot = abstractclientplayer.elytraRotZ;
        } else {
            leftWing.xRot = f;
            leftWing.zRot = f1;
            leftWing.yRot = f3;
        }
        rightWing.yRot = -leftWing.yRot;
        rightWing.y = leftWing.y;
        rightWing.xRot = leftWing.xRot;
        rightWing.zRot = -leftWing.zRot;
    }

    private void animateHeart(float age) {
        float val = Mth.sin((float)(age / 6.0f)) / 6.0f;
        this.heart.xScale = 1.0f + val;
        this.heart.zScale = 1.0f + val;
        this.heart.yScale = 1.0f - val;
    }

    private void animatePupil(T living) {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity != null) {
            Vec3 vec3 = entity.getEyePosition(0.0f);
            Vec3 vec31 = living.getEyePosition(0.0f);
            double d0 = vec3.y - vec31.y;
            this.pupil.y = d0 > 0.0 ? this.pupil.getInitialPose().y - 1.0f : this.pupil.getInitialPose().y;
            Vec3 vec32 = living.getViewVector(0.0f);
            vec32 = new Vec3(vec32.x, 0.0, vec32.z);
            Vec3 vec33 = new Vec3(vec31.x - vec3.x, 0.0, vec31.z - vec3.z).normalize().yRot(1.5707964f);
            double d1 = vec32.dot(vec33);
            this.pupil.x = this.pupil.getInitialPose().x + 0.35f + Mth.sqrt((float)((float)Math.abs(d1))) * 1.5f * (float)Math.signum(d1);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateTumor(this.lob1, Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f);
        this.animateTumor(this.lob2, Mth.cos((float)(ageInTicks / 8.0f)) / 10.0f);
        this.animatedElytra(entity, this.leftJoint, this.rightJoint);
        this.right_for_wing.zRot = this.rightJoint.zRot / 2.0f;
        this.left_for_wing.zRot = this.leftJoint.zRot / 2.0f;
        this.animatePupil(entity);
        this.animateHeart(ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.headwear.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pelvis.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

