/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class livingArmorModelBase<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"livingarmormodel"), "main");
    public final ModelPart headwear;
    private final ModelPart tendril;
    public final ModelPart body;
    private final ModelPart heart;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart pelvis;
    public final ModelPart leftBoot;
    public final ModelPart rightBoot;

    public livingArmorModelBase() {
        ModelPart root = livingArmorModelBase.createBodyLayer().bakeRoot();
        this.headwear = root.getChild("headwear");
        this.tendril = this.headwear.getChild("tendril");
        this.body = root.getChild("body");
        this.heart = this.body.getChild("heart");
        this.rightArm = root.getChild("rightArm");
        this.leftArm = root.getChild("leftArm");
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
        this.pelvis = root.getChild("pelvis");
        this.leftBoot = root.getChild("leftBoot");
        this.rightBoot = root.getChild("rightBoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition headwear = partdefinition.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.2f)).texOffs(96, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)).texOffs(32, 6).addBox(-1.0f, -9.0f, -4.0f, 2.0f, 1.0f, 8.0f, new CubeDeformation(1.0f)).texOffs(27, -12).addBox(0.0f, -12.0f, -6.0f, 0.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(64, -8).addBox(-3.0f, -10.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(64, -8).addBox(3.0f, -10.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition brain_r1 = headwear.addOrReplaceChild("brain_r1", CubeListBuilder.create().texOffs(82, 9).addBox(-3.0f, -4.0f, 0.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril = headwear.addOrReplaceChild("tendril", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-2.0f, (float)7.0f));
        PartDefinition cube_r1 = tendril.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(96, 9).addBox(1.0f, -1.9281f, -1.611f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.6f, (float)0.0f, (float)0.3927f, (float)0.4363f, (float)0.0f));
        PartDefinition cube_r2 = tendril.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(96, 9).addBox(1.0f, -1.9281f, -1.611f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.6f, (float)-1.0f, (float)0.3927f, (float)-0.4363f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.15f)).texOffs(104, 22).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(110, 43).mirror().addBox(-1.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(120, 43).addBox(-2.0f, -2.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.2f, (float)0.0f));
        PartDefinition cube_r5 = spine.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(62, 38).addBox(-1.0f, -0.2294f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.24f)), PartPose.offsetAndRotation((float)0.0f, (float)9.166f, (float)3.3f, (float)-1.3852f, (float)0.0095f, (float)0.0174f));
        PartDefinition cube_r6 = spine.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(60, 19).addBox(-1.0f, -0.2294f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)8.032f, (float)3.0f, (float)-1.7279f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = spine.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -0.2294f, -3.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.23f)), PartPose.offsetAndRotation((float)0.0f, (float)11.536f, (float)2.4f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = spine.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(62, 44).addBox(-1.0f, -0.6287f, -1.5094f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.23f)), PartPose.offsetAndRotation((float)0.0f, (float)3.418f, (float)2.85f, (float)-1.3788f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = spine.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(62, 41).addBox(-1.0f, 0.4781f, -2.8277f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)3.218f, (float)4.0f, (float)-1.3439f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = spine.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(52, 39).addBox(-1.0f, -2.06f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.24f)), PartPose.offsetAndRotation((float)0.0f, (float)6.584f, (float)1.65f, (float)-1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition heart = body.addOrReplaceChild("heart", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.1f, (float)3.8f, (float)-2.55f, (float)-0.1572f, (float)-0.0832f, (float)0.3065f));
        PartDefinition body_r1 = heart.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(118, 40).addBox(-0.8381f, -0.5587f, -0.95f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)-0.0752f, (float)-0.8348f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r2 = heart.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(122, 38).addBox(0.8381f, -0.9413f, -1.05f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-1.2273f, (float)-0.5898f, (float)-0.35f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition body_r3 = heart.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(112, 38).addBox(-2.1619f, -2.9413f, -1.05f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.8f)), PartPose.offsetAndRotation((float)-0.8252f, (float)0.4152f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(24, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(88, 22).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r11 = rightArm.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(30, 62).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)9.0f, (float)0.8f, (float)0.0f, (float)1.5708f, (float)-3.1416f));
        PartDefinition cube_r12 = rightArm.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(62, 30).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)9.0f, (float)-1.2f, (float)0.0f, (float)1.5708f, (float)-3.1416f));
        PartDefinition right_arm_r1 = rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(14, 50).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition right_arm_r2 = rightArm.addOrReplaceChild("right_arm_r2", CubeListBuilder.create().texOffs(58, 60).addBox(-4.0f, -11.0f, -1.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.6f, (float)2.3f, (float)0.0f, (float)0.0f, (float)-0.3752f));
        PartDefinition right_arm_r3 = rightArm.addOrReplaceChild("right_arm_r3", CubeListBuilder.create().texOffs(50, 60).addBox(-4.0f, -11.0f, -1.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)3.0f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0262f));
        PartDefinition right_arm_r4 = rightArm.addOrReplaceChild("right_arm_r4", CubeListBuilder.create().texOffs(32, 43).addBox(-4.0f, -12.0f, -1.0f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)1.2f, (float)-0.8f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition right_arm_r5 = rightArm.addOrReplaceChild("right_arm_r5", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -11.0f, -1.0f, 7.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(72, 22).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r13 = leftArm.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(24, 56).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)9.0f, (float)-1.2f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition cube_r14 = leftArm.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(62, 5).addBox(0.1f, -5.0f, -1.0f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9f, (float)9.0f, (float)0.8f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition left_arm_r1 = leftArm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(16, 32).addBox(0.2f, 0.0f, -3.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.4f)), PartPose.offsetAndRotation((float)4.8f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.2654f));
        PartDefinition left_arm_r2 = leftArm.addOrReplaceChild("left_arm_r2", CubeListBuilder.create().texOffs(40, 15).addBox(-1.8f, -4.0f, -3.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(16, 39).addBox(-2.1f, -1.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.6f)).texOffs(88, 35).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r15 = rightLeg.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 64).addBox(0.0f, -2.0f, -1.0f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)-3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = rightLeg.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(60, 14).addBox(0.0f, 1.75f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)-1.75f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = rightLeg.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -0.25f, -1.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)-2.0f, (float)-0.5f, (float)3.25f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(36, 32).addBox(-1.9f, -1.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.61f)).texOffs(72, 35).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r18 = leftLeg.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(0, 64).addBox(0.0f, -2.0f, -1.0f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)-3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = leftLeg.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(52, 6).addBox(0.0f, -0.25f, -1.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.61f)), PartPose.offsetAndRotation((float)-2.0f, (float)-0.5f, (float)3.25f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = leftLeg.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(40, 60).addBox(0.0f, 1.75f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.61f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)-1.75f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition pelvis = partdefinition.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(104, 32).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftBoot = partdefinition.addOrReplaceChild("leftBoot", CubeListBuilder.create().texOffs(46, 43).addBox(-1.9f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.11f)).texOffs(112, 48).addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r21 = leftBoot.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(56, 52).addBox(0.0f, -2.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = leftBoot.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(30, 54).addBox(-0.1f, -3.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.2f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)-0.2618f, (float)0.0f));
        PartDefinition cube_r23 = leftBoot.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(46, 52).addBox(0.1f, -3.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)0.2618f, (float)0.0f));
        PartDefinition rightBoot = partdefinition.addOrReplaceChild("rightBoot", CubeListBuilder.create().texOffs(40, 22).addBox(-1.9f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.12f)).texOffs(96, 48).addBox(-1.8f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(1.01f)), PartPose.offset((float)-2.1f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r24 = rightBoot.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(56, 22).addBox(0.0f, -2.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r25 = rightBoot.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(14, 56).addBox(-0.1f, -3.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)-0.2618f, (float)0.0f));
        PartDefinition cube_r26 = rightBoot.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(52, 31).addBox(0.1f, -3.0f, -1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)13.0f, (float)-6.0f, (float)0.1745f, (float)0.2618f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateHeart(float age) {
        float val = Mth.sin((float)(age / 6.0f)) / 6.0f;
        this.heart.xScale = 1.0f + val;
        this.heart.zScale = 1.0f + val;
        this.heart.yScale = 1.0f - val;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateHeart(ageInTicks);
        this.tendril.xRot = Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.headwear.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pelvis.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

