/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Animations.VerwaAnimations;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class verwahrungModel<T extends Verwa>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"verwahrung"), "main");
    private final ModelPart SporePod;
    private final ModelPart BaseTumor;
    private final ModelPart Petals;
    private final ModelPart TopJaw;
    private final ModelPart BottomJaw;

    public verwahrungModel(ModelPart root) {
        this.SporePod = root.getChild("SporePod");
        this.BaseTumor = this.SporePod.getChild("TumorBase");
        this.Petals = this.SporePod.getChild("Base").getChild("Petals");
        this.TopJaw = this.SporePod.getChild("Base").getChild("Jaw").getChild("TopJawJoint");
        this.BottomJaw = this.SporePod.getChild("Base").getChild("Jaw").getChild("BottomJawJoint");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition SporePod = partdefinition.addOrReplaceChild("SporePod", CubeListBuilder.create(), PartPose.offset((float)-0.85f, (float)24.0f, (float)-3.0f));
        PartDefinition TumorBase = SporePod.addOrReplaceChild("TumorBase", CubeListBuilder.create(), PartPose.offset((float)2.0062f, (float)-1.7921f, (float)4.1882f));
        PartDefinition Biomass_r1 = TumorBase.addOrReplaceChild("Biomass_r1", CubeListBuilder.create().texOffs(2, 1).addBox(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8989f, (float)-0.1307f, (float)0.8938f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Biomass_r2 = TumorBase.addOrReplaceChild("Biomass_r2", CubeListBuilder.create().texOffs(4, 2).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7817f, (float)0.206f, (float)8.7818f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Biomass_r3 = TumorBase.addOrReplaceChild("Biomass_r3", CubeListBuilder.create().texOffs(8, 4).addBox(3.0f, -3.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6765f, (float)1.6273f, (float)-4.3262f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Biomass_r4 = TumorBase.addOrReplaceChild("Biomass_r4", CubeListBuilder.create().texOffs(6, 3).addBox(-8.0f, -5.0f, 7.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5928f, (float)-3.8534f, (float)-6.2058f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition Biomass_r5 = TumorBase.addOrReplaceChild("Biomass_r5", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0887f, (float)0.7284f, (float)-4.7513f, (float)-0.329f, (float)-1.0983f, (float)1.1961f));
        PartDefinition Base = SporePod.addOrReplaceChild("Base", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Petals = Base.addOrReplaceChild("Petals", CubeListBuilder.create(), PartPose.offset((float)0.85f, (float)-5.0f, (float)3.0f));
        PartDefinition Petal1 = Petals.addOrReplaceChild("Petal1", CubeListBuilder.create().texOffs(8, 114).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.15f, (float)0.0f, (float)-5.5f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r1 = Petal1.addOrReplaceChild("Membrane_r1", CubeListBuilder.create().texOffs(95, 92).addBox(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r2 = Petal1.addOrReplaceChild("Membrane_r2", CubeListBuilder.create().texOffs(98, 7).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal1Middle = Petal1.addOrReplaceChild("Petal1Middle", CubeListBuilder.create().texOffs(0, 113).addBox(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r3 = Petal1Middle.addOrReplaceChild("Membrane_r3", CubeListBuilder.create().texOffs(100, 105).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9653f, (float)-0.0245f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r4 = Petal1Middle.addOrReplaceChild("Membrane_r4", CubeListBuilder.create().texOffs(14, 90).addBox(1.0f, -11.0f, 0.0f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9653f, (float)-0.0245f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal1Top = Petal1Middle.addOrReplaceChild("Petal1Top", CubeListBuilder.create().texOffs(32, 117).addBox(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r5 = Petal1Top.addOrReplaceChild("Membrane_r5", CubeListBuilder.create().texOffs(110, 0).addBox(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.224f, (float)-0.0823f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r6 = Petal1Top.addOrReplaceChild("Membrane_r6", CubeListBuilder.create().texOffs(111, 31).addBox(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.224f, (float)-0.0823f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor1 = Petal1Top.addOrReplaceChild("PetalTumor1", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-12.0f, (float)1.0f));
        PartDefinition Tumors_r1 = PetalTumor1.addOrReplaceChild("Tumors_r1", CubeListBuilder.create().texOffs(12, 12).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1237f, (float)0.6269f, (float)0.543f));
        PartDefinition Petal2 = Petals.addOrReplaceChild("Petal2", CubeListBuilder.create().texOffs(8, 114).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.8563f, (float)0.0f, (float)-0.8541f, (float)0.48f, (float)-1.2566f, (float)0.0f));
        PartDefinition Membrane_r7 = Petal2.addOrReplaceChild("Membrane_r7", CubeListBuilder.create().texOffs(95, 92).addBox(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)0.0f, (float)-0.1459f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r8 = Petal2.addOrReplaceChild("Membrane_r8", CubeListBuilder.create().texOffs(98, 7).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)0.0f, (float)-0.1459f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal2Middle = Petal2.addOrReplaceChild("Petal2Middle", CubeListBuilder.create().texOffs(0, 113).addBox(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r9 = Petal2Middle.addOrReplaceChild("Membrane_r9", CubeListBuilder.create().texOffs(14, 90).addBox(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)-0.9653f, (float)-0.1704f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r10 = Petal2Middle.addOrReplaceChild("Membrane_r10", CubeListBuilder.create().texOffs(99, 105).addBox(-8.0f, -11.0f, 0.0f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)-0.9653f, (float)-0.1704f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal2Top = Petal2Middle.addOrReplaceChild("Petal2Top", CubeListBuilder.create().texOffs(32, 117).addBox(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r11 = Petal2Top.addOrReplaceChild("Membrane_r11", CubeListBuilder.create().texOffs(110, 0).addBox(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)-1.224f, (float)-0.2282f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r12 = Petal2Top.addOrReplaceChild("Membrane_r12", CubeListBuilder.create().texOffs(111, 31).addBox(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0437f, (float)-1.224f, (float)-0.2282f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor2 = Petal2Top.addOrReplaceChild("PetalTumor2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.7063f, (float)-12.0f, (float)0.3541f, (float)0.3054f, (float)-0.48f, (float)0.0f));
        PartDefinition Tumors_r2 = PetalTumor2.addOrReplaceChild("Tumors_r2", CubeListBuilder.create().texOffs(12, 12).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal2TopFungus = Petal2Top.addOrReplaceChild("Petal2TopFungus", CubeListBuilder.create(), PartPose.offset((float)1.0843f, (float)-5.0632f, (float)0.4243f));
        PartDefinition Fungus_r1 = Petal2TopFungus.addOrReplaceChild("Fungus_r1", CubeListBuilder.create().texOffs(-7, 31).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6907f, (float)-2.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r2 = Petal2TopFungus.addOrReplaceChild("Fungus_r2", CubeListBuilder.create().texOffs(-7, 24).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1907f, (float)-0.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r3 = Petal2TopFungus.addOrReplaceChild("Fungus_r3", CubeListBuilder.create().texOffs(-7, 38).addBox(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r4 = Petal2TopFungus.addOrReplaceChild("Fungus_r4", CubeListBuilder.create().texOffs(-7, 38).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Petal3 = Petals.addOrReplaceChild("Petal3", CubeListBuilder.create().texOffs(8, 114).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.6767f, (float)0.0f, (float)5.8541f, (float)-2.6616f, (float)-0.6283f, (float)3.1416f));
        PartDefinition Membrane_r13 = Petal3.addOrReplaceChild("Membrane_r13", CubeListBuilder.create().texOffs(95, 92).addBox(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r14 = Petal3.addOrReplaceChild("Membrane_r14", CubeListBuilder.create().texOffs(98, 7).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal3Middle = Petal3.addOrReplaceChild("Petal3Middle", CubeListBuilder.create().texOffs(0, 113).addBox(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r15 = Petal3Middle.addOrReplaceChild("Membrane_r15", CubeListBuilder.create().texOffs(100, 105).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1233f, (float)-0.9653f, (float)-0.3786f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r16 = Petal3Middle.addOrReplaceChild("Membrane_r16", CubeListBuilder.create().texOffs(14, 90).addBox(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1233f, (float)-0.9653f, (float)-0.3786f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal3Top = Petal3Middle.addOrReplaceChild("Petal3Top", CubeListBuilder.create().texOffs(32, 114).addBox(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r17 = Petal3Top.addOrReplaceChild("Membrane_r17", CubeListBuilder.create().texOffs(110, 0).addBox(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0267f, (float)-1.224f, (float)-0.9364f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r18 = Petal3Top.addOrReplaceChild("Membrane_r18", CubeListBuilder.create().texOffs(111, 31).addBox(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0267f, (float)-1.224f, (float)-0.9364f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor3 = Petal3Top.addOrReplaceChild("PetalTumor3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.703f, (float)-11.1962f, (float)0.4198f, (float)0.4638f, (float)-0.3305f, (float)-0.3961f));
        PartDefinition Tumors_r3 = PetalTumor3.addOrReplaceChild("Tumors_r3", CubeListBuilder.create().texOffs(12, 12).addBox(-2.0f, -2.0f, -3.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0994f, (float)-0.6744f, (float)0.5342f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal4 = Petals.addOrReplaceChild("Petal4", CubeListBuilder.create().texOffs(8, 114).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.3767f, (float)0.0f, (float)5.8541f, (float)-2.6616f, (float)0.6283f, (float)3.1416f));
        PartDefinition Membrane_r19 = Petal4.addOrReplaceChild("Membrane_r19", CubeListBuilder.create().texOffs(95, 92).addBox(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r20 = Petal4.addOrReplaceChild("Membrane_r20", CubeListBuilder.create().texOffs(98, 7).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal4Middle = Petal4.addOrReplaceChild("Petal4Middle", CubeListBuilder.create().texOffs(0, 113).addBox(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r21 = Petal4Middle.addOrReplaceChild("Membrane_r21", CubeListBuilder.create().texOffs(100, 105).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)-0.9653f, (float)-0.6286f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r22 = Petal4Middle.addOrReplaceChild("Membrane_r22", CubeListBuilder.create().texOffs(14, 90).addBox(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)-0.9653f, (float)-0.6286f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal4Top = Petal4Middle.addOrReplaceChild("Petal4Top", CubeListBuilder.create().texOffs(32, 115).addBox(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r23 = Petal4Top.addOrReplaceChild("Membrane_r23", CubeListBuilder.create().texOffs(110, 0).addBox(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)-0.974f, (float)-0.9364f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r24 = Petal4Top.addOrReplaceChild("Membrane_r24", CubeListBuilder.create().texOffs(111, 31).addBox(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0267f, (float)-0.974f, (float)-0.9364f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor4Sub1 = Petal4Top.addOrReplaceChild("PetalTumor4Sub1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.7565f, (float)-11.1962f, (float)0.4198f, (float)0.562f, (float)-0.0231f, (float)-0.935f));
        PartDefinition Tumors_r4 = PetalTumor4Sub1.addOrReplaceChild("Tumors_r4", CubeListBuilder.create().texOffs(12, 12).addBox(-1.0f, -1.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0994f, (float)-0.6744f, (float)0.5342f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition PetalTumor4Sub2 = Petal4Top.addOrReplaceChild("PetalTumor4Sub2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.7467f, (float)-11.3437f, (float)0.2392f, (float)0.7093f, (float)0.1835f, (float)-1.2706f));
        PartDefinition Tumors_r5 = PetalTumor4Sub2.addOrReplaceChild("Tumors_r5", CubeListBuilder.create().texOffs(12, 12).addBox(0.0f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2981f, (float)-2.0231f, (float)1.6025f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal4BaseFungus = Petal4.addOrReplaceChild("Petal4BaseFungus", CubeListBuilder.create(), PartPose.offset((float)0.8174f, (float)-6.8392f, (float)0.7984f));
        PartDefinition Fungus_r5 = Petal4BaseFungus.addOrReplaceChild("Fungus_r5", CubeListBuilder.create().texOffs(-7, 38).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6907f, (float)-2.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r6 = Petal4BaseFungus.addOrReplaceChild("Fungus_r6", CubeListBuilder.create().texOffs(-7, 24).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1907f, (float)-0.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r7 = Petal4BaseFungus.addOrReplaceChild("Fungus_r7", CubeListBuilder.create().texOffs(-7, 31).addBox(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r8 = Petal4BaseFungus.addOrReplaceChild("Fungus_r8", CubeListBuilder.create().texOffs(-7, 31).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Petal5 = Petals.addOrReplaceChild("Petal5", CubeListBuilder.create().texOffs(8, 114).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5231f, (float)0.0f, (float)-0.9534f, (float)0.48f, (float)1.2392f, (float)0.0f));
        PartDefinition Membrane_r25 = Petal5.addOrReplaceChild("Membrane_r25", CubeListBuilder.create().texOffs(98, 7).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1731f, (float)0.0f, (float)-0.5466f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r26 = Petal5.addOrReplaceChild("Membrane_r26", CubeListBuilder.create().texOffs(95, 92).addBox(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1731f, (float)0.0f, (float)-0.5466f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal5Middle = Petal5.addOrReplaceChild("Petal5Middle", CubeListBuilder.create().texOffs(0, 113).addBox(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r27 = Petal5Middle.addOrReplaceChild("Membrane_r27", CubeListBuilder.create().texOffs(14, 90).addBox(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0769f, (float)-0.9653f, (float)-0.8211f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r28 = Petal5Middle.addOrReplaceChild("Membrane_r28", CubeListBuilder.create().texOffs(100, 105).addBox(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0769f, (float)-0.9653f, (float)-0.8211f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal5Top = Petal5Middle.addOrReplaceChild("Petal5Top", CubeListBuilder.create().texOffs(32, 117).addBox(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r29 = Petal5Top.addOrReplaceChild("Membrane_r29", CubeListBuilder.create().texOffs(110, 0).addBox(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0269f, (float)-0.974f, (float)-1.1289f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r30 = Petal5Top.addOrReplaceChild("Membrane_r30", CubeListBuilder.create().texOffs(111, 31).addBox(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0269f, (float)-0.974f, (float)-1.1289f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor5 = Petal5Top.addOrReplaceChild("PetalTumor5", CubeListBuilder.create(), PartPose.offset((float)0.9029f, (float)-13.1962f, (float)2.2273f));
        PartDefinition Tumors_r6 = PetalTumor5.addOrReplaceChild("Tumors_r6", CubeListBuilder.create().texOffs(12, 12).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-1.0994f, (float)0.3256f, (float)-0.4658f, (float)0.2451f, (float)0.6705f, (float)0.231f));
        PartDefinition Petal5MiddleFungus = Petal5Middle.addOrReplaceChild("Petal5MiddleFungus", CubeListBuilder.create(), PartPose.offset((float)0.4638f, (float)-5.8045f, (float)0.5814f));
        PartDefinition Fungus_r9 = Petal5MiddleFungus.addOrReplaceChild("Fungus_r9", CubeListBuilder.create().texOffs(-7, 31).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3093f, (float)-4.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r10 = Petal5MiddleFungus.addOrReplaceChild("Fungus_r10", CubeListBuilder.create().texOffs(-7, 24).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1907f, (float)-1.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r11 = Petal5MiddleFungus.addOrReplaceChild("Fungus_r11", CubeListBuilder.create().texOffs(-7, 31).addBox(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r12 = Petal5MiddleFungus.addOrReplaceChild("Fungus_r12", CubeListBuilder.create().texOffs(-7, 38).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Jaw = Base.addOrReplaceChild("Jaw", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.8576f, (float)-5.1743f, (float)5.0f, (float)1.5708f, (float)-1.4835f, (float)-3.1416f));
        PartDefinition TopJawJoint = Jaw.addOrReplaceChild("TopJawJoint", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-11.0f, (float)3.0f));
        PartDefinition TopJaw = TopJawJoint.addOrReplaceChild("TopJaw", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.3838f, (float)1.1721f, (float)0.8621f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition HeadLeftTeeth_r1 = TopJaw.addOrReplaceChild("HeadLeftTeeth_r1", CubeListBuilder.create().texOffs(71, 85).mirror().addBox(-2.75f, 3.35f, -4.0f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(56, 56).addBox(-2.75f, -3.25f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)5.5847f, (float)0.1825f, (float)-6.2745f, (float)-0.1372f, (float)-0.0042f, (float)0.4948f));
        PartDefinition HeadCenter_r1 = TopJaw.addOrReplaceChild("HeadCenter_r1", CubeListBuilder.create().texOffs(0, 63).addBox(-5.5f, -3.0f, -4.5f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.7894f, (float)-1.0826f, (float)-5.7788f, (float)0.1309f, (float)0.0f, (float)0.0436f));
        PartDefinition HeadRightTeeth_r1 = TopJaw.addOrReplaceChild("HeadRightTeeth_r1", CubeListBuilder.create().texOffs(71, 85).addBox(-4.0f, 0.6f, -2.75f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)).texOffs(24, 71).addBox(-4.0f, -5.0f, -2.75f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-5.597f, (float)1.5661f, (float)-7.0181f, (float)0.1309f, (float)0.0f, (float)-0.3491f));
        PartDefinition BottomJawJoint = Jaw.addOrReplaceChild("BottomJawJoint", CubeListBuilder.create(), PartPose.offset((float)-1.6315f, (float)1.8279f, (float)2.8621f));
        PartDefinition BottomJaw = BottomJawJoint.addOrReplaceChild("BottomJaw", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6906f, (float)-0.1119f, (float)0.1343f));
        PartDefinition HeadLeft_r1 = BottomJaw.addOrReplaceChild("HeadLeft_r1", CubeListBuilder.create().texOffs(24, 56).addBox(-2.75f, -3.75f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)5.5847f, (float)-0.1825f, (float)-6.2745f, (float)-0.0555f, (float)-0.1071f, (float)-0.484f));
        PartDefinition HeadCenter_r2 = BottomJaw.addOrReplaceChild("HeadCenter_r2", CubeListBuilder.create().texOffs(48, 0).addBox(-5.5f, -2.75f, -4.5f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.7894f, (float)1.0826f, (float)-5.7788f, (float)-0.1309f, (float)0.0f, (float)-0.0436f));
        PartDefinition HeadRightTeeth_r2 = BottomJaw.addOrReplaceChild("HeadRightTeeth_r2", CubeListBuilder.create().texOffs(71, 85).addBox(-4.0f, -1.0f, -1.5f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-5.5951f, (float)-1.5804f, (float)-8.277f, (float)0.1309f, (float)0.0f, (float)-3.0107f));
        PartDefinition HeadRight_r1 = BottomJaw.addOrReplaceChild("HeadRight_r1", CubeListBuilder.create().texOffs(67, 25).addBox(-4.0f, 0.75f, -2.75f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-5.597f, (float)-1.5661f, (float)-7.0181f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition InternalDetails = Base.addOrReplaceChild("InternalDetails", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-5.0f, (float)4.0f));
        PartDefinition Plane_r1 = InternalDetails.addOrReplaceChild("Plane_r1", CubeListBuilder.create().texOffs(0, 131).addBox(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.15f, (float)-8.0f, (float)0.0f, (float)-3.0107f, (float)-1.0472f, (float)3.1416f));
        PartDefinition Plane_r2 = InternalDetails.addOrReplaceChild("Plane_r2", CubeListBuilder.create().texOffs(0, 131).mirror().addBox(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.15f, (float)-8.0f, (float)0.0f, (float)-0.0873f, (float)-0.9599f, (float)0.0f));
        PartDefinition Plane_r3 = InternalDetails.addOrReplaceChild("Plane_r3", CubeListBuilder.create().texOffs(0, 131).addBox(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.15f, (float)-8.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)-0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    private void animateTumor(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 7.0f)) / 7.0f;
        part.yScale = 1.0f + Mth.cos((float)(value / 7.0f)) / 7.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 7.0f)) / 7.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.ScaleModel(entity, this.SporePod);
        this.animate(((Verwa)((Object)entity)).burst, VerwaAnimations.BURST, ageInTicks, 1.0f);
        this.animateTumor(this.BaseTumor, ageInTicks);
        this.Petals.xRot = Mth.cos((float)(ageInTicks / 10.0f)) / 10.0f;
        this.Petals.zRot = Mth.cos((float)(ageInTicks / 10.0f)) / 10.0f;
        this.TopJaw.xRot = Mth.cos((float)(ageInTicks / 7.0f)) / 7.0f;
        this.BottomJaw.xRot = -this.TopJaw.xRot;
    }

    private void ScaleModel(T type, ModelPart part) {
        Entity entity = ((Verwa)((Object)type)).getStoredEntity();
        if (entity.getBbWidth() > type.getBbWidth()) {
            float w = entity.getBbWidth();
            part.xScale = w - 0.3f;
            part.zScale = w - 0.3f;
        }
        if (entity.getBbHeight() > type.getBbHeight()) {
            float h = entity.getBbHeight();
            part.yScale = h - 1.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.SporePod.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    public ModelPart root() {
        return this.SporePod;
    }
}

