/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.BraionmilBabe;
import com.Harbinger.Spore.Client.Models.BraionmilModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Braionmil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BraioRenderer
extends BaseInfectedRenderer<Braionmil, EntityModel<Braionmil>> {
    private final EntityModel<Braionmil> normalBraio = this.getModel();
    private final EntityModel<Braionmil> babeBraio;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/baio.png");
    private static final ResourceLocation BABE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/braio_babe.png");
    private static final ResourceLocation EYE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/baio.png");

    public BraioRenderer(EntityRendererProvider.Context context) {
        super(context, new BraionmilModel(context.bakeLayer(BraionmilModel.LAYER_LOCATION)), 0.5f);
        this.babeBraio = new BraionmilBabe<Braionmil>(context.bakeLayer(BraionmilBabe.LAYER_LOCATION));
    }

    protected boolean isBabe(Braionmil braionmil) {
        return Objects.equals(braionmil.getCustomName(), Component.literal((String)"Babe"));
    }

    public ResourceLocation getTextureLocation(Braionmil entity) {
        return this.isBabe(entity) ? BABE_TEXTURE : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYE_TEXTURE;
    }

    @Override
    public void render(Braionmil braionmil, float p_115456_, float p_115457_, PoseStack stack, MultiBufferSource bufferSource, int p_115460_) {
        this.model = this.isBabe(braionmil) ? this.babeBraio : this.normalBraio;
        super.render(braionmil, p_115456_, p_115457_, stack, bufferSource, p_115460_);
    }
}

