/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.BulletModel;
import com.Harbinger.Spore.Sentities.Projectile.AdaptableProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BulletRender
extends EntityRenderer<AdaptableProjectile> {
    BulletModel<AdaptableProjectile> model;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/noise.png");

    public BulletRender(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BulletModel(context.bakeLayer(BulletModel.LAYER_LOCATION));
    }

    public void render(AdaptableProjectile adaptableProjectile, float p_114486_, float p_114487_, PoseStack stack, MultiBufferSource bufferSource, int value) {
        super.render((Entity)adaptableProjectile, p_114486_, p_114487_, stack, bufferSource, value);
        int i = adaptableProjectile.getParticles();
        stack.pushPose();
        stack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(adaptableProjectile)));
        this.model.renderToBuffer(stack, vertexconsumer, value, OverlayTexture.NO_OVERLAY, i);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(AdaptableProjectile entity) {
        return TEXTURE;
    }
}

