/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.BusserModel;
import com.Harbinger.Spore.Client.Models.ExplodingBusserModel;
import com.Harbinger.Spore.Client.Models.RangedBusserModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Busser;
import com.Harbinger.Spore.Sentities.Variants.BusserVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BusserRenderer
extends BaseInfectedRenderer<Busser, EntityModel<Busser>> {
    private final EntityModel<Busser> normalBusser = this.getModel();
    private final EntityModel<Busser> explodingBusser;
    private final EntityModel<Busser> toxic_busser;
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/busser.png");
    public static final Map<BusserVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(BusserVariants.class), p_114874_ -> {
        p_114874_.put(BusserVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/busser.png"));
        p_114874_.put(BusserVariants.ENHANCED, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/busser_aggressive.png"));
        p_114874_.put(BusserVariants.BOMBER, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/busserbomber.png"));
        p_114874_.put(BusserVariants.TOXIC, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/toxic_busser.png"));
    });

    public BusserRenderer(EntityRendererProvider.Context context) {
        super(context, new BusserModel(context.bakeLayer(BusserModel.LAYER_LOCATION)), 0.5f);
        this.explodingBusser = new ExplodingBusserModel<Busser>(context.bakeLayer(ExplodingBusserModel.LAYER_LOCATION));
        this.toxic_busser = new RangedBusserModel<Busser>(context.bakeLayer(RangedBusserModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Busser entity) {
        return TEXTURE.get((Object)entity.getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    protected void scale(Busser type, PoseStack stack, float value) {
        if (type.getVariant() == BusserVariants.ENHANCED) {
            float size = 1.4f;
            stack.scale(size, size, size);
        }
        super.scale((LivingEntity)type, stack, value);
    }

    @Override
    public void render(Busser busser, float p_115456_, float p_115457_, PoseStack stack, MultiBufferSource bufferSource, int p_115460_) {
        EntityModel<Busser> entityModel = this.normalBusser;
        if (busser.getVariant() == BusserVariants.BOMBER) {
            entityModel = this.explodingBusser;
        }
        if (busser.getVariant() == BusserVariants.TOXIC) {
            entityModel = this.toxic_busser;
        }
        this.model = entityModel;
        super.render(busser, p_115456_, p_115457_, stack, bufferSource, p_115460_);
    }
}

