/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.CalamityPartsHandeling;
import com.Harbinger.Spore.Sentities.Utility.CorpseEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CorpseRenderer<T extends CorpseEntity>
extends EntityRenderer<T> {
    public CalamityPartsHandeling.Part partToRender;

    public CorpseRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(T t) {
        return this.partToRender == null ? ResourceLocation.parse((String)"spore:textures/entity/empty.png") : (((CorpseEntity)((Object)t)).getOwnerAda() ? this.partToRender.adapted_location() : this.partToRender.location());
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource source, int light) {
        if (this.partToRender == null || this.partToRender.id() != ((CorpseEntity)((Object)entity)).getCorpseType()) {
            this.partToRender = CalamityPartsHandeling.getPart(((CorpseEntity)((Object)entity)).getCorpseType());
            if (this.partToRender == null) {
                return;
            }
        }
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((CorpseEntity)((Object)entity)).yRotO, (float)entity.getYRot())));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((CorpseEntity)((Object)entity)).xRotO, (float)entity.getXRot())));
        stack.pushPose();
        float scaleValue = ((CorpseEntity)((Object)entity)).getInflation();
        stack.scale(scaleValue, scaleValue, scaleValue);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f + this.partToRender.xRot()));
        stack.mulPose(Axis.YP.rotationDegrees(this.partToRender.yRot()));
        stack.mulPose(Axis.ZP.rotationDegrees(this.partToRender.zRot()));
        stack.translate(-this.partToRender.z(), -this.partToRender.y(), -this.partToRender.x());
        this.renderPart(entity, stack, source, light);
        stack.popPose();
        stack.popPose();
    }

    private void renderPart(T entity, PoseStack stack, MultiBufferSource source, int light) {
        int color = ((CorpseEntity)((Object)entity)).getColor();
        VertexConsumer baseConsumer = source.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        for (ModelPart part : this.partToRender.parts()) {
            part.render(stack, baseConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        }
        if (color != 0) {
            int overlayColor = color & 0xFFFFFF | Integer.MIN_VALUE;
            VertexConsumer overlayConsumer = source.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
            for (ModelPart part : this.partToRender.parts()) {
                part.render(stack, overlayConsumer, light, OverlayTexture.NO_OVERLAY, overlayColor);
            }
        }
    }
}

