/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.BileRound;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FleshBombRenderer<T extends FleshBomb>
extends EntityRenderer<T> {
    public static final ResourceLocation BASIC_ROUND = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/basicround.png");
    public static final ResourceLocation FLAMMABLE_ROUND = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/fireround.png");
    public static final ResourceLocation BILE_ROUND = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/bileround.png");
    public static final ResourceLocation ACID_ROUND = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/acidround.png");
    public static final ResourceLocation NUCLEAR_ROUND = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/nuclear_round.png");
    private final BileRound<T> model = new BileRound();

    public FleshBombRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float value2, float value, PoseStack stack, MultiBufferSource source, int p_116116_) {
        stack.pushPose();
        stack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)value, (float)((FleshBomb)((Object)entity)).yRotO, (float)entity.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)value, (float)((FleshBomb)((Object)entity)).xRotO, (float)entity.getXRot()) + 90.0f));
        int scaling = ((FleshBomb)((Object)entity)).getCarrier() ? 2 : 1;
        stack.scale((float)scaling, (float)scaling, (float)scaling);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)this.model.renderType(this.getTextureLocation((FleshBomb)((Object)entity))), (boolean)false, (boolean)false);
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)((FleshBomb)((Object)entity)).tickCount, 0.0f, 0.0f);
        this.model.renderToBuffer(stack, vertexconsumer, p_116116_, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        super.render(entity, value2, value, stack, source, p_116116_);
    }

    public ResourceLocation getTextureLocation(FleshBomb bileProjectile) {
        if (bileProjectile.getBombType() == 1) {
            return FLAMMABLE_ROUND;
        }
        if (bileProjectile.getBombType() == 2) {
            return BILE_ROUND;
        }
        if (bileProjectile.getBombType() == 3) {
            return ACID_ROUND;
        }
        if (bileProjectile.getBombType() == 4) {
            return NUCLEAR_ROUND;
        }
        return BASIC_ROUND;
    }
}

