/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.GazenbrecherModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.Calamities.Gazenbrecher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GazenRenderer<Type extends Gazenbrecher>
extends CalamityRenderer<Type, GazenbrecherModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/gazen.png");
    private static final ResourceLocation ADAPTED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/burned_gazen.png");
    private static final ResourceLocation EYE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/gazen.png");

    public GazenRenderer(EntityRendererProvider.Context context) {
        super(context, new GazenbrecherModel(context.bakeLayer(GazenbrecherModel.LAYER_LOCATION)), 4.0f);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Gazenbrecher)entity).isAdaptedToFire() ? ADAPTED_TEXTURE : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYE_TEXTURE;
    }
}

