/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HevokerModel;
import com.Harbinger.Spore.Client.Models.HevokerModelDead;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.Hyper.Hevoker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HevokerRenderer
extends BaseInfectedRenderer<Hevoker, EntityModel<Hevoker>> {
    private final EntityModel<Hevoker> normalBraio = this.getModel();
    private final EntityModel<Hevoker> deadHevoker;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hyper_evoker.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/hyper_evoker.png");

    public HevokerRenderer(EntityRendererProvider.Context context) {
        super(context, new HevokerModel(context.bakeLayer(HevokerModel.LAYER_LOCATION)), 1.0f);
        this.deadHevoker = new HevokerModelDead<Hevoker>(context.bakeLayer(HevokerModelDead.LAYER_LOCATION));
        this.addLayer(new TotemLayer(this, context.getItemInHandRenderer()));
        this.addLayer(new VolatileGlowingLayers(this));
    }

    public ResourceLocation getTextureLocation(Hevoker hevoker) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    @Override
    protected boolean isShaking(Hevoker type) {
        return super.isShaking(type) || type.isFakeDead();
    }

    @Override
    public void render(Hevoker hevoker, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        this.model = hevoker.isFakeDead() ? this.deadHevoker : this.normalBraio;
        super.render(hevoker, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    private static class TotemLayer<T extends Hevoker, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public TotemLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (((Hevoker)((Object)t)).isFakeDead()) {
                ItemStack stack = new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
                poseStack.pushPose();
                poseStack.translate(0.0f, 1.0f, 0.3f);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(30.0f));
                this.itemInHandRenderer.renderItem(t, stack, ItemDisplayContext.FIXED, true, poseStack, multiBufferSource, i);
                poseStack.popPose();
            }
        }
    }

    static class VolatileGlowingLayers<T extends Hevoker, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hyper_evoker_glow.png");

        public VolatileGlowingLayers(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isInvisible() && !((Hevoker)((Object)entity)).isFakeDead()) {
                float alpha = 0.5f + 0.5f * Mth.sin((float)(ageInTicks * 0.1f));
                int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
                VertexConsumer vertexConsumer = buffer.getBuffer(SporeRenderTypes.glowingTranslucent(TEXTURE));
                this.getParentModel().renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
            }
        }
    }
}

