/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.HindenburgLightsLayer;
import com.Harbinger.Spore.Client.Models.HindieModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.Calamities.Hinderburg;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HindieRenderer<Type extends Hinderburg>
extends CalamityRenderer<Type, HindieModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie.png");
    private static final ResourceLocation OVERCLOCKED = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_adapted.png");
    private static final ResourceLocation EYE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/hindie.png");

    public HindieRenderer(EntityRendererProvider.Context context) {
        super(context, new HindieModel(context.bakeLayer(HindieModel.LAYER_LOCATION)), 4.0f);
        this.addLayer(new HindenburgLightsLayer(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Hinderburg)entity).isAdapted() ? OVERCLOCKED : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYE_TEXTURE;
    }
}

