/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg1Model;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg2Model;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg3Model;
import com.Harbinger.Spore.Client.Models.hohlfresserTailModel;
import com.Harbinger.Spore.Sentities.BaseEntities.HohlMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class HohlSegRenderer<Type extends HohlMultipart>
extends LivingEntityRenderer<Type, EntityModel<Type>> {
    public static final Map<HohlMultipart.SegmentVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(HohlMultipart.SegmentVariants.class), p_114874_ -> {
        p_114874_.put(HohlMultipart.SegmentVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hohl/hohl_seg1.png"));
        p_114874_.put(HohlMultipart.SegmentVariants.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hohl/hohl_seg2.png"));
        p_114874_.put(HohlMultipart.SegmentVariants.ORGAN, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hohl/hohl_seg3.png"));
    });
    private static final ResourceLocation INNARDS = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/worm_innards.png");
    private static final ResourceLocation TAIL = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hohl/hohl_seg1.png");
    private final EntityModel<Type> mainSegment = this.getModel();
    private final EntityModel<Type> meleeSegment;
    private final EntityModel<Type> organSegment;
    private final EntityModel<Type> tailModel;

    public HohlSegRenderer(EntityRendererProvider.Context context) {
        super(context, new HohlfresserSeg1Model(context.bakeLayer(HohlfresserSeg1Model.LAYER_LOCATION)), 4.0f);
        this.meleeSegment = new HohlfresserSeg2Model<Type>(context.bakeLayer(HohlfresserSeg2Model.LAYER_LOCATION));
        this.organSegment = new HohlfresserSeg3Model<Type>(context.bakeLayer(HohlfresserSeg3Model.LAYER_LOCATION));
        this.tailModel = new hohlfresserTailModel<Type>(context.bakeLayer(hohlfresserTailModel.LAYER_LOCATION));
        this.addLayer(new HohlColors(this, this));
        this.addLayer(new HohlEmmisive(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((HohlMultipart)entity).isTail() ? TAIL : TEXTURE.get((Object)((HohlMultipart)entity).getSegmentVariant());
    }

    protected void scale(Type type, PoseStack stack, float p_115316_) {
        float size = ((HohlMultipart)type).getSize();
        stack.scale(size, size, size);
        super.scale(type, stack, p_115316_);
    }

    public EntityModel<Type> getSegmentModel(Type type) {
        switch (((HohlMultipart)type).getSegmentVariant()) {
            case MELEE: {
                return this.meleeSegment;
            }
            case ORGAN: {
                return this.organSegment;
            }
        }
        return this.mainSegment;
    }

    public void render(Type type, float val1, float val2, PoseStack stack, MultiBufferSource source, int light) {
        Entity parent;
        this.model = ((HohlMultipart)type).isTail() ? this.tailModel : this.getSegmentModel(type);
        super.render(type, val1, val2, stack, source, light);
        if (type.isInvisible()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        int i = ((HohlMultipart)type).getParentIntId();
        if (level != null && i != -1 && (parent = level.getEntity(i)) != null) {
            this.renderConnection(type, parent, stack, source, val2);
        }
    }

    protected boolean shouldShowName(Type p_115333_) {
        return false;
    }

    private void renderConnection(Type parent, Entity to, PoseStack stack, MultiBufferSource buffer, float partialTick) {
        float f;
        if (to instanceof HohlMultipart) {
            HohlMultipart hohlMultipart = (HohlMultipart)to;
            f = hohlMultipart.getSize();
        } else {
            f = to instanceof Hohlfresser ? 1.2f : 0.0f;
        }
        float i = f;
        Vec3 start = parent.getPosition(partialTick).add(0.0, (double)(parent.getBbHeight() * 0.3f * ((HohlMultipart)parent).getSize()), 0.0);
        Vec3 end = to.getPosition(partialTick).add(0.0, (double)(to.getBbHeight() * 0.45f * i), 0.0);
        Vec3 direction = end.subtract(start);
        float length = (float)direction.length();
        direction = direction.normalize();
        float yaw = (float)Math.atan2(direction.x, direction.z);
        float pitch = (float)(-Math.asin(direction.y));
        int color = ((HohlMultipart)parent).getColor() == 0 ? -1 : ((HohlMultipart)parent).getColor();
        stack.pushPose();
        Vec3 vec3 = parent.position().subtract(parent.position()).scale(-1.0);
        stack.translate(vec3.x, vec3.y + 1.0, vec3.z);
        stack.mulPose(Axis.YP.rotation(yaw));
        stack.mulPose(Axis.XP.rotation(pitch));
        float inf = 0.6f;
        float startWidth = parent.getBbWidth() * inf * ((HohlMultipart)parent).getSize();
        float startHeight = parent.getBbHeight() * inf * ((HohlMultipart)parent).getSize();
        float endWidth = to.getBbWidth() * inf * i;
        float endHeight = to.getBbHeight() * inf * i;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)INNARDS));
        PoseStack.Pose pose = stack.last();
        Matrix4f matrix = pose.pose();
        this.drawTaperedConnection(vertexConsumer, matrix, pose, startWidth, startHeight, endWidth, endHeight, length, OverlayTexture.NO_OVERLAY, 0xF000F0, color);
        stack.popPose();
    }

    private void drawTaperedConnection(VertexConsumer consumer, Matrix4f pose, PoseStack.Pose realPose, float startWidth, float startHeight, float endWidth, float endHeight, float length, int overlay, int lightmap, int packedColor) {
        float hwStart = startWidth / 2.0f;
        float hhStart = startHeight / 2.0f;
        float hwEnd = endWidth / 2.0f;
        float hhEnd = endHeight / 2.0f;
        consumer.addVertex(pose, -hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, hwStart, hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, -hwStart, hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, -hwEnd, -hhEnd, length).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, hwEnd, -hhEnd, length).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, hwEnd, hhEnd, length).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, -hwEnd, hhEnd, length).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, -hwStart, hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, hwStart, hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, hwEnd, hhEnd, length).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, -hwEnd, hhEnd, length).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, -hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, hwEnd, -hhEnd, length).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, -hwEnd, -hhEnd, length).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, -hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, -hwStart, hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, -hwEnd, hhEnd, length).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, -hwEnd, -hhEnd, length).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, hwStart, -hhStart, 0.0f).setColor(packedColor).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, hwStart, hhStart, 0.0f).setColor(packedColor).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, hwEnd, hhEnd, length).setColor(packedColor).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, hwEnd, -hhEnd, length).setColor(packedColor).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(lightmap).setNormal(realPose, 1.0f, 0.0f, 0.0f);
    }

    public class HohlColors<T extends HohlMultipart, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        public HohlColors(HohlSegRenderer this$0, RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int val, T type, float v, float v1, float v2, float v3, float v4, float v5) {
            if (!type.isInvisible()) {
                if (((HohlMultipart)type).getColor() == 0) {
                    return;
                }
                int i = ((HohlMultipart)type).getColor();
                int r = i >> 16 & 0xFF;
                int g = i >> 8 & 0xFF;
                int b = i & 0xFF;
                int halfColor = Integer.MIN_VALUE | r << 16 | g << 8 | b;
                VertexConsumer consumer = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)type)));
                this.getParentModel().renderToBuffer(poseStack, consumer, val, OverlayTexture.NO_OVERLAY, halfColor);
            }
        }
    }

    static class HohlEmmisive<T extends HohlMultipart, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hohl/hohl_bile.png");

        public HohlEmmisive(RenderLayerParent<T, M> renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isInvisible() && ((HohlMultipart)entity).getSegmentVariant() == HohlMultipart.SegmentVariants.ORGAN && !((HohlMultipart)entity).isTail()) {
                float alpha = 0.5f + 0.5f * Mth.sin((float)(ageInTicks * 0.1f));
                int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
                VertexConsumer vertexConsumer = buffer.getBuffer(SporeRenderTypes.glowingTranslucent(TEXTURE));
                this.getParentModel().renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
            }
        }
    }
}

