/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.HowitzerEmissiveLayer;
import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HowitzerModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.Calamities.Howitzer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HowitzerRenderer<Type extends Howitzer>
extends CalamityRenderer<Type, HowitzerModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/howitzer.png");
    private static final ResourceLocation RADIATION = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/nuclear_howitzer.png");
    private static final ResourceLocation EYE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/howitzer_eyes.png");

    public HowitzerRenderer(EntityRendererProvider.Context context) {
        super(context, new HowitzerModel(context.bakeLayer(HowitzerModel.LAYER_LOCATION)), 4.0f);
        this.addLayer(new HowitzerNeonGreenLayer(this));
        this.addLayer(new HowitzerEmissiveLayer(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Howitzer)entity).isRadioactive() ? RADIATION : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYE_TEXTURE;
    }

    static class HowitzerNeonGreenLayer<T extends Howitzer, M extends HowitzerModel<T>>
    extends RenderLayer<T, M> {
        public HowitzerNeonGreenLayer(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float ageInTicks, float v4, float v5) {
            int ticksBoom = ((Howitzer)t).getSelfDetonation();
            if (!t.isInvisible() && ((Howitzer)t).isRadioactive() && ticksBoom > 0) {
                float pulse = 0.7f + 0.3f * Mth.sin((float)(ageInTicks * 0.2f));
                float progress = Mth.clamp((float)(1.0f - (float)ticksBoom / 30.0f), (float)0.0f, (float)1.0f);
                float alpha = 0.15f + 0.45f * (pulse * progress);
                float red = 0.2f + 0.1f * pulse;
                float green = 0.9f + 0.1f * pulse;
                float blue = 0.2f;
                int r = (int)(red * 255.0f);
                int g = (int)(green * 255.0f);
                int b = (int)(blue * 255.0f);
                int a = (int)(alpha * 255.0f);
                int color = a << 24 | r << 16 | g << 8 | b;
                VertexConsumer consumer = multiBufferSource.getBuffer(SporeRenderTypes.glowingTranslucent(RADIATION));
                ((HowitzerModel)this.getParentModel()).renderToBuffer(poseStack, consumer, i, OverlayTexture.NO_OVERLAY, color);
            }
        }
    }
}

