/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.HowlerModel;
import com.Harbinger.Spore.Client.Models.SculkHowlerModel;
import com.Harbinger.Spore.Client.Models.bansheeHowlerModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Howler;
import com.Harbinger.Spore.Sentities.Variants.HowlerVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HowlerRenderer<Type extends Howler>
extends BaseInfectedRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel = this.getModel();
    private final EntityModel<Type> banshee;
    private final EntityModel<Type> sculk;
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/howler.png");
    public static final Map<HowlerVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(HowlerVariants.class), p_114874_ -> {
        p_114874_.put(HowlerVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/howler.png"));
        p_114874_.put(HowlerVariants.BANSHEE, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/freaky_howler.png"));
        p_114874_.put(HowlerVariants.SONIC, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/sculkhowler.png"));
    });

    public HowlerRenderer(EntityRendererProvider.Context context) {
        super(context, new HowlerModel(context.bakeLayer(HowlerModel.LAYER_LOCATION)), 0.5f);
        this.banshee = new bansheeHowlerModel<Type>(context.bakeLayer(bansheeHowlerModel.LAYER_LOCATION));
        this.sculk = new SculkHowlerModel<Type>(context.bakeLayer(SculkHowlerModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Howler)entity).getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    @Override
    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.model = ((Howler)type).getVariant() == HowlerVariants.BANSHEE ? this.banshee : (((Howler)type).getVariant() == HowlerVariants.SONIC ? this.sculk : this.defaultModel);
        super.render(type, value1, value2, stack, bufferSource, light);
    }
}

