/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.hVindicatorModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.Hyper.Hvindicator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HyperVindicatorRenderer<Type extends Hvindicator>
extends BaseInfectedRenderer<Type, hVindicatorModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindicator.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/hindicator.png");

    public HyperVindicatorRenderer(EntityRendererProvider.Context context) {
        super(context, new hVindicatorModel(context.bakeLayer(hVindicatorModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new AxeLayer(this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    static class AxeLayer<T extends Hvindicator, M extends hVindicatorModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public AxeLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (((Hvindicator)((Object)t)).hasAxe()) {
                ItemStack stack = new ItemStack((ItemLike)Items.IRON_AXE);
                poseStack.pushPose();
                this.moveItemAround((hVindicatorModel)this.getParentModel(), poseStack);
                poseStack.translate(-0.15, 0.3, -0.5);
                poseStack.scale(1.4f, 1.4f, 1.4f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-10.0f));
                this.itemInHandRenderer.renderItem(t, stack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, true, poseStack, multiBufferSource, i);
                poseStack.popPose();
            }
        }

        void moveItemAround(M model, PoseStack stack) {
            ((hVindicatorModel)model).getHand().translateAndRotate(stack);
        }
    }
}

