/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class IllusionRenderer
extends EntityRenderer<Illusion> {
    private final EntityRenderDispatcher entityRenderer;
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"spore:textures/entity/empty.png");

    public IllusionRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.entityRenderer = context.getEntityRenderDispatcher();
    }

    public ResourceLocation getTextureLocation(Illusion illusion) {
        return TEXTURE;
    }

    protected float getBob(Illusion illusion, float p_115306_) {
        return (float)illusion.tickCount + p_115306_;
    }

    public void render(Illusion illusion, float value1, float value2, PoseStack stack, MultiBufferSource source, int light) {
        if (illusion.getSeeAble()) {
            this.renderIllusions(illusion, value2, stack, source, light);
        } else {
            Player player;
            Entity entity = Minecraft.getInstance().cameraEntity;
            if (entity instanceof Player && (player = (Player)entity).getId() == illusion.getTargetId()) {
                this.renderIllusions(illusion, value2, stack, source, light);
            }
        }
        super.render((Entity)illusion, value1, value2, stack, source, light);
    }

    public void renderIllusions(Illusion illusion, float value2, PoseStack stack, MultiBufferSource source, int light) {
        ResourceLocation location = ResourceLocation.parse((String)illusion.getBody());
        EntityType<?> entityType = Utilities.tryToCreateEntity(location);
        LivingEntity entity = (LivingEntity)entityType.create(illusion.level());
        float f = Mth.rotLerp((float)value2, (float)illusion.yBodyRotO, (float)illusion.yBodyRot);
        float f1 = Mth.rotLerp((float)value2, (float)illusion.yHeadRotO, (float)illusion.yHeadRot);
        float f2 = f1 - f;
        float f6 = Mth.lerp((float)value2, (float)illusion.xRotO, (float)illusion.getXRot());
        float f7 = this.getBob(illusion, value2);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (illusion.isAlive()) {
            f8 = illusion.walkAnimation.speed(value2);
            f5 = illusion.walkAnimation.position(value2);
            if (illusion.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        if (entity != null) {
            stack.pushPose();
            stack.mulPose(Axis.YP.rotationDegrees(-illusion.yBodyRot));
            stack.mulPose(Axis.XP.rotationDegrees(180.0f));
            stack.translate(0.0, -1.5, 0.0);
            EntityRenderer entityRenderer = this.entityRenderer.getRenderer((Entity)entity);
            if (entityRenderer instanceof MobRenderer) {
                MobRenderer mobRenderer = (MobRenderer)entityRenderer;
                EntityModel model = mobRenderer.getModel();
                ResourceLocation texture = mobRenderer.getTextureLocation((Entity)entity);
                VertexConsumer consumer = source.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
                model.prepareMobModel((Entity)entity, f5, f8, value2);
                model.setupAnim((Entity)entity, f5, f8, f7, f2, f6);
                model.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY, -1);
            }
            stack.popPose();
        }
    }
}

