/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.InfectedHazmatCoat;
import com.Harbinger.Spore.Client.Models.InfectedHazmatModel;
import com.Harbinger.Spore.Client.Models.InfectedHazmatWithTank;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedHazmat;
import com.Harbinger.Spore.Sentities.Variants.HazmatVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfectedHazmatRenderer
extends MobRenderer<InfectedHazmat, EntityModel<InfectedHazmat>> {
    private final EntityModel<InfectedHazmat> normalHazmat = this.getModel();
    private final EntityModel<InfectedHazmat> tankHazmat;
    private final EntityModel<InfectedHazmat> coatHazmat;
    public static final Map<HazmatVariant, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(HazmatVariant.class), p_114874_ -> {
        p_114874_.put(HazmatVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/inf_hazmat.png"));
        p_114874_.put(HazmatVariant.TANK, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/inf_hazmat.png"));
        p_114874_.put(HazmatVariant.COAT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/inf_hazmat_coat.png"));
    });

    public InfectedHazmatRenderer(EntityRendererProvider.Context context) {
        super(context, new InfectedHazmatModel(context.bakeLayer(InfectedHazmatModel.LAYER_LOCATION)), 0.5f);
        this.tankHazmat = new InfectedHazmatWithTank<InfectedHazmat>(context.bakeLayer(InfectedHazmatWithTank.LAYER_LOCATION));
        this.coatHazmat = new InfectedHazmatCoat<InfectedHazmat>(context.bakeLayer(InfectedHazmatCoat.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(InfectedHazmat hazmat) {
        return TEXTURE.get((Object)hazmat.getVariant());
    }

    public void render(InfectedHazmat infectedHazmat, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        EntityModel<InfectedHazmat> entityModel = infectedHazmat.getVariant() == HazmatVariant.TANK ? this.tankHazmat : (infectedHazmat.getVariant() == HazmatVariant.COAT ? this.coatHazmat : this.normalHazmat);
        this.model = entityModel;
        super.render((LivingEntity)infectedHazmat, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }
}

