/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.CustomArmorLayer;
import com.Harbinger.Spore.Client.Models.InfectedPlayerModel;
import com.Harbinger.Spore.Client.Models.InfectedTechnoModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.Variants.InfPlayerSkins;
import com.Harbinger.Spore.core.Seffects;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfectedPlayerRenderer
extends BaseInfectedRenderer<InfectedPlayer, HumanoidModel<InfectedPlayer>> {
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/inf_player.png");
    private final HumanoidModel<InfectedPlayer> mainModel = (HumanoidModel)this.getModel();
    private final HumanoidModel<InfectedPlayer> technoSkin;
    private final HumanoidModel<InfectedPlayer> madnessModel;
    public static final Map<InfPlayerSkins, ResourceLocation> MAIN_TEXTURES = (Map)Util.make((Object)Maps.newEnumMap(InfPlayerSkins.class), p_114874_ -> {
        p_114874_.put(InfPlayerSkins.STEVE, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_steve.png"));
        p_114874_.put(InfPlayerSkins.ALEX, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_alex.png"));
        p_114874_.put(InfPlayerSkins.EFE, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_efe.png"));
        p_114874_.put(InfPlayerSkins.MAKENA, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_makena.png"));
        p_114874_.put(InfPlayerSkins.SUNNY, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_sunny.png"));
        p_114874_.put(InfPlayerSkins.ZURI, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_zuri.png"));
        p_114874_.put(InfPlayerSkins.ARI, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_ari.png"));
        p_114874_.put(InfPlayerSkins.KAI, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_kai.png"));
        p_114874_.put(InfPlayerSkins.NO0R, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_noor.png"));
    });
    public static final Map<InfPlayerSkins, ResourceLocation> MADNESS_TEXTURES = (Map)Util.make((Object)Maps.newEnumMap(InfPlayerSkins.class), p_114874_ -> {
        p_114874_.put(InfPlayerSkins.STEVE, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/steve.png"));
        p_114874_.put(InfPlayerSkins.ALEX, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/alex.png"));
        p_114874_.put(InfPlayerSkins.EFE, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/efe.png"));
        p_114874_.put(InfPlayerSkins.MAKENA, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/makena.png"));
        p_114874_.put(InfPlayerSkins.SUNNY, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/sunny.png"));
        p_114874_.put(InfPlayerSkins.ZURI, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/zuri.png"));
        p_114874_.put(InfPlayerSkins.ARI, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/ari.png"));
        p_114874_.put(InfPlayerSkins.KAI, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/kai.png"));
        p_114874_.put(InfPlayerSkins.NO0R, ResourceLocation.parse((String)"minecraft:textures/entity/player/wide/noor.png"));
    });
    public static final Map<Component, ResourceLocation> SPECIAL_SKINS = new HashMap<Component, ResourceLocation>(){
        {
            this.put(Component.literal((String)"Technoblade"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/techno_skin.png"));
            this.put(Component.literal((String)"CODATOWER"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_coda_skin.png"));
            this.put(Component.literal((String)"Flash62724"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_slasher.png"));
            this.put(Component.literal((String)"TVGuy"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_blura.png"));
            this.put(Component.literal((String)"mrlambert6"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_lambert.png"));
            this.put(Component.literal((String)"NexouuZ"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_nexouuz.png"));
            this.put(Component.literal((String)"SyrCrypt"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_syrcrypt.png"));
            this.put(Component.literal((String)"KaratFeng"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_karat_skin.png"));
            this.put(Component.literal((String)"BigXplosion"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_explosion_skin.png"));
            this.put(Component.literal((String)"Toasteroni"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_toast.png"));
            this.put(Component.literal((String)"Dr_Pilot_MOO"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/dr_pilot_moo.png"));
            this.put(Component.literal((String)"UnmeiHa"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_nunny.png"));
            this.put(Component.literal((String)"AllToAshes"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_alltoashes.png"));
            this.put(Component.literal((String)"0dna"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_0dna.png"));
            this.put(Component.literal((String)"PedroHenrry"), ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/player/inf_player_pedro.png"));
        }
    };

    public InfectedPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, new InfectedPlayerModel(context.bakeLayer(InfectedPlayerModel.LAYER_LOCATION)), 0.5f);
        this.madnessModel = new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER));
        this.technoSkin = new InfectedTechnoModel<InfectedPlayer>(context.bakeLayer(InfectedTechnoModel.LAYER_LOCATION));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer(new CustomArmorLayer(this));
    }

    public ResourceLocation getTextureLocation(InfectedPlayer infectedPlayer) {
        if (this.isTheViewerMad(infectedPlayer)) {
            return MADNESS_TEXTURES.get((Object)infectedPlayer.getVariant());
        }
        Component component = infectedPlayer.getName();
        ResourceLocation location = SPECIAL_SKINS.get(component);
        if (location != null) {
            return location;
        }
        return MAIN_TEXTURES.get((Object)infectedPlayer.getVariant());
    }

    public boolean isTheViewerMad(InfectedPlayer infectedPlayer) {
        Entity entity = Minecraft.getInstance().cameraEntity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MobEffectInstance instance = player.getEffect(Seffects.MADNESS);
            return instance != null && instance.getAmplifier() > 0 && player.distanceTo((Entity)infectedPlayer) > 30.0f;
        }
        return false;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    @Override
    public void render(InfectedPlayer type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.model = this.isTheViewerMad(type) ? this.madnessModel : (Objects.equals(type.getCustomName(), Component.literal((String)"Technoblade")) ? this.technoSkin : this.mainModel);
        super.render(type, value1, value2, stack, bufferSource, light);
    }
}

