/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.JagdhundModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Jagdhund;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JagdhundRenderer<Type extends Jagdhund>
extends BaseInfectedRenderer<Type, JagdhundModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/jagdhund.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/jagdhund.png");

    public JagdhundRenderer(EntityRendererProvider.Context context) {
        super(context, new JagdhundModel(context.bakeLayer(JagdhundModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    @Override
    public void render(Type type, float p_115456_, float p_115457_, PoseStack stack, MultiBufferSource bufferSource, int p_115460_) {
        float f = this.shadowRadius = ((Jagdhund)((Object)type)).isUnderground() ? 0.0f : 0.5f;
        if (((Jagdhund)((Object)type)).isBurrowing() || ((Jagdhund)((Object)type)).isEmerging()) {
            float a = type.getBbHeight() * 2.0f;
            float b = 0.0f;
            if (((Jagdhund)((Object)type)).isBurrowing()) {
                b = 0.0f - a / (float)((Jagdhund)((Object)type)).getBorrow_tick() * (float)((Jagdhund)((Object)type)).getBorrow();
            } else if (((Jagdhund)((Object)type)).isEmerging()) {
                b = -0.5f - a + a / (float)((Jagdhund)((Object)type)).getEmerge_tick() * (float)((Jagdhund)((Object)type)).getEmerge();
            }
            stack.translate(0.0, (double)b, 0.0);
        }
        if (!((Jagdhund)((Object)type)).isUnderground() || ((Jagdhund)((Object)type)).isEmerging() || ((Jagdhund)((Object)type)).isBurrowing()) {
            super.render(type, p_115456_, p_115457_, stack, bufferSource, p_115460_);
        }
    }

    @Override
    protected boolean isShaking(Type type) {
        return super.isShaking(type) || ((Jagdhund)((Object)type)).isBurrowing() || ((Jagdhund)((Object)type)).isEmerging();
    }
}

