/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.InfectedSpearModel;
import com.Harbinger.Spore.Sentities.Projectile.ThrownKnife;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class KnifeRenderer
extends EntityRenderer<ThrownKnife> {
    public static final ResourceLocation Spear_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/infected_knife.png");
    private final InfectedSpearModel<ThrownKnife> model;

    public KnifeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new InfectedSpearModel(context.bakeLayer(InfectedSpearModel.LAYER_LOCATION));
    }

    public void render(ThrownKnife knife, float p_116112_, float p_116113_, PoseStack stack, MultiBufferSource p_116115_, int p_116116_) {
        int color = knife.getColor() == 0 ? -1 : knife.getColor();
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)p_116113_, (float)knife.yRotO, (float)knife.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)p_116113_, (float)knife.xRotO, (float)knife.getXRot()) + 90.0f));
        stack.scale(0.4f, 0.4f, 0.4f);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)p_116115_, (RenderType)this.model.renderType(this.getTextureLocation(knife)), (boolean)false, (boolean)knife.isFoil());
        this.model.renderToBuffer(stack, vertexconsumer, p_116116_, OverlayTexture.NO_OVERLAY, color);
        stack.popPose();
        super.render((Entity)knife, p_116112_, p_116113_, stack, p_116115_, p_116116_);
    }

    @NotNull
    public ResourceLocation getTextureLocation(ThrownKnife p_116109_) {
        return Spear_LOCATION;
    }
}

