/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.MepheticBottle;
import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.MephiticModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Mephetic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MephticRenderer<Type extends Mephetic>
extends BaseInfectedRenderer<Type, MephiticModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/mephitic.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/mephitic.png");

    public MephticRenderer(EntityRendererProvider.Context context) {
        super(context, new MephiticModel(context.bakeLayer(MephiticModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new MepheticBottle(this));
        this.addLayer(new VolatileGlowingLayers(this));
        this.addLayer(new VolatileGlowingLayers.PotionLayer(this, context.getItemInHandRenderer()));
        this.addLayer(new VolatileGlowingLayers.HeldDrink(this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    static class VolatileGlowingLayers<T extends Mephetic, M extends MephiticModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/mephitic_glow.png");

        public VolatileGlowingLayers(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float alpha = 0.5f + 0.5f * Mth.sin((float)(ageInTicks * 0.1f));
            int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            VertexConsumer vertexConsumer = buffer.getBuffer(SporeRenderTypes.glowingTranslucent(TEXTURE));
            ((MephiticModel)this.getParentModel()).renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }

        static class HeldDrink<T extends Mephetic, M extends MephiticModel<T>>
        extends RenderLayer<T, M> {
            private final ItemInHandRenderer itemInHandRenderer;

            public HeldDrink(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
                super(parent);
                this.itemInHandRenderer = itemInHandRenderer;
            }

            public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
                this.renderItem(poseStack, t, multiBufferSource, i, t.getMainHandItem(), 0.0f);
                this.renderItem(poseStack, t, multiBufferSource, i, t.getOffhandItem(), 0.1f);
            }

            private void renderItem(PoseStack poseStack, T entity, MultiBufferSource source, int light, ItemStack stack, float offset) {
                poseStack.pushPose();
                ((MephiticModel)this.getParentModel()).OffarmParts.forEach(part -> part.translateAndRotate(poseStack));
                poseStack.translate(0.2 + (double)offset, 1.1, 0.0);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                this.itemInHandRenderer.renderItem(entity, stack, ItemDisplayContext.FIXED, true, poseStack, source, light);
                poseStack.popPose();
            }
        }

        static class PotionLayer<T extends Mephetic, M extends MephiticModel<T>>
        extends RenderLayer<T, M> {
            private final ItemInHandRenderer itemInHandRenderer;

            public PotionLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
                super(parent);
                this.itemInHandRenderer = itemInHandRenderer;
            }

            public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
                if (((Mephetic)((Object)t)).getPotions().isEmpty() || ((Mephetic)((Object)t)).getPotions().size() < 3) {
                    return;
                }
                this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(0), -0.05f, 0.05f);
                this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(1), 0.0f, 0.0f);
                this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(2), 0.05f, -0.05f);
            }

            private void renderItem(PoseStack poseStack, T entity, MultiBufferSource source, int light, ItemStack stack, float x, float y) {
                poseStack.pushPose();
                ((MephiticModel)this.getParentModel()).armParts.forEach(part -> part.translateAndRotate(poseStack));
                poseStack.translate(-0.15 + (double)x, (double)(1.0f + y), 0.0);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                this.itemInHandRenderer.renderItem(entity, stack, ItemDisplayContext.FIXED, true, poseStack, source, light);
                poseStack.popPose();
            }
        }
    }
}

