/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.MoundModel;
import com.Harbinger.Spore.Client.Special.OrganoidMobRenderer;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoundRenderer<Type extends Mound>
extends OrganoidMobRenderer<Type, MoundModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/mound.png");
    private static final ResourceLocation TEXTURE_LARGE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/mound_large.png");
    private static final ResourceLocation TEXTURE_LINKED = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/linked_mounds.png");
    private static final ResourceLocation TEXTURE_LARGE_LINKED = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/mound_large_linked.png");

    public MoundRenderer(EntityRendererProvider.Context context) {
        super(context, new MoundModel(context.bakeLayer(MoundModel.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(Mound mound, PoseStack poseStack, float p_115316_) {
        int scale = Math.max(mound.getAge(), 1);
        poseStack.scale((float)scale, (float)scale, (float)scale);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        if (((Mound)entity).getAge() >= 3) {
            return ((Mound)entity).getLinked() ? TEXTURE_LARGE_LINKED : TEXTURE_LARGE;
        }
        return ((Mound)entity).getLinked() ? TEXTURE_LINKED : TEXTURE;
    }
}

