/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.NukeParts.BombFunnelModel;
import com.Harbinger.Spore.Client.Models.NukeParts.FireDiskModel;
import com.Harbinger.Spore.Client.Models.NukeParts.MushroomExplosionTop;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class NuclearBombRenderer<T extends NukeEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TOP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/bomb/top.png");
    private static final ResourceLocation FUNNEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/bomb/funnel.png");
    private static final ResourceLocation RING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/bomb/fire_disk.png");
    private final BombFunnelModel<T> funnelModel = new BombFunnelModel();
    private final FireDiskModel<T> fireDiskModel = new FireDiskModel();
    private final MushroomExplosionTop<T> mushroomExplosionTop = new MushroomExplosionTop();

    public NuclearBombRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(T t) {
        return null;
    }

    public void renderTop(T bomb, PoseStack stack, MultiBufferSource bufferSource) {
        stack.pushPose();
        stack.scale(0.95f, 1.05f, 0.95f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)TOP_TEXTURE));
        this.mushroomExplosionTop.renderToBuffer(stack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
    }

    public void renderRing(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.pushPose();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)RING_TEXTURE));
        this.fireDiskModel.renderToBuffer(stack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
        this.fireDiskModel.setupAnim(bomb, 0.0f, 0.0f, ticks, 0.0f, 0.0f);
        stack.popPose();
    }

    public void renderFire(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.pushPose();
        float uOffset = ticks * 0.01f % 1.0f;
        float vOffset = ticks * 0.01f * 2.0f % 1.0f;
        RenderType renderType = SporeRenderTypes.energySwirlStatic(FUNNEL_TEXTURE, uOffset, vOffset);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(renderType);
        this.funnelModel.renderToBuffer(stack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
    }

    public void renderTopFire(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.pushPose();
        float uOffset = ticks * 0.01f % 1.0f;
        float vOffset = ticks * 0.01f * 2.0f % 1.0f;
        RenderType renderType = SporeRenderTypes.energySwirlStatic(FUNNEL_TEXTURE, -uOffset, -vOffset);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(renderType);
        this.mushroomExplosionTop.renderToBuffer(stack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
    }

    public void render(T bomb, float entityYaw, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int value) {
        float ticks = (float)((NukeEntity)((Object)bomb)).tickCount + partialTick;
        stack.pushPose();
        float scale = this.inflate(bomb);
        float yOffset = 1.5f * (1.0f / scale);
        stack.translate(0.0f, yOffset, 0.0f);
        stack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        stack.translate(0.0, -((double)((NukeEntity)((Object)bomb)).getInitRange() / 1.2), 0.0);
        stack.scale(scale, scale, scale);
        this.renderTopFire(bomb, ticks, stack, bufferSource);
        this.renderFire(bomb, ticks, stack, bufferSource);
        this.renderTop(bomb, stack, bufferSource);
        this.renderRing(bomb, ticks, stack, bufferSource);
        stack.popPose();
        super.render(bomb, entityYaw, partialTick, stack, bufferSource, value);
    }

    public float inflate(T bomb) {
        return Math.max(((NukeEntity)((Object)bomb)).getInitRange(), 1.0f);
    }
}

