/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.DrownedScamperModel;
import com.Harbinger.Spore.Client.Models.ScamperModel;
import com.Harbinger.Spore.Client.Models.ScamperVillagerModel;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScamperHumanRenderer
extends MobRenderer<Scamper, EntityModel<Scamper>> {
    private final EntityModel<Scamper> defaultModel = this.getModel();
    private final EntityModel<Scamper> villagerModel;
    private final EntityModel<Scamper> drownedModel;
    public static final Map<ScamperVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(ScamperVariants.class), p_114874_ -> {
        p_114874_.put(ScamperVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/scamper.png"));
        p_114874_.put(ScamperVariants.VILLAGER, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/villager_scamper.png"));
        p_114874_.put(ScamperVariants.DROWNED, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/drowned_scamper.png"));
    });

    public ScamperHumanRenderer(EntityRendererProvider.Context context) {
        super(context, new ScamperModel(context.bakeLayer(ScamperModel.LAYER_LOCATION)), 0.5f);
        this.villagerModel = new ScamperVillagerModel<Scamper>(context.bakeLayer(ScamperVillagerModel.LAYER_LOCATION));
        this.drownedModel = new DrownedScamperModel<Scamper>(context.bakeLayer(DrownedScamperModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Scamper scamper) {
        return TEXTURE.get((Object)scamper.getVariant());
    }

    public void render(Scamper scamper, float value1, float value2, PoseStack stack, MultiBufferSource source, int value3) {
        this.model = scamper.getVariant() == ScamperVariants.VILLAGER ? this.villagerModel : (scamper.getVariant() == ScamperVariants.DROWNED ? this.drownedModel : this.defaultModel);
        super.render((LivingEntity)scamper, value1, value2, stack, source, value3);
    }
}

