/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SiegerArrowLayer;
import com.Harbinger.Spore.Client.Layers.SiegerHatLayer;
import com.Harbinger.Spore.Client.Models.SiegerModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.Calamities.Sieger;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SiegerRenderer<Type extends Sieger>
extends CalamityRenderer<Type, SiegerModel<Type>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/sieger.png");
    private static final ResourceLocation WAR = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/war_sieger.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/sieger.png");

    public SiegerRenderer(EntityRendererProvider.Context context) {
        super(context, new SiegerModel(context.bakeLayer(SiegerModel.LAYER_LOCATION)), 4.0f);
        this.addLayer(new SiegerHatLayer(this, context.getModelSet()));
        this.addLayer(new SiegerArrowLayer(this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Sieger)entity).isAdapted() ? WAR : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }
}

