/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.GrabberSlasherModel;
import com.Harbinger.Spore.Client.Models.SlasherModel;
import com.Harbinger.Spore.Client.Models.SmasherSlasherModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Slasher;
import com.Harbinger.Spore.Sentities.Variants.SlasherVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class SlasherRenderer<Type extends Slasher>
extends BaseInfectedRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel;
    private final EntityModel<Type> smasher;
    private final GrabberSlasherModel<Type> grabber;
    public static final Map<SlasherVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(SlasherVariants.class), p_114874_ -> {
        p_114874_.put(SlasherVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/slasher.png"));
        p_114874_.put(SlasherVariants.PIERCER, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/piercer.png"));
        p_114874_.put(SlasherVariants.SMASHER, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/smasher_slasher.png"));
        p_114874_.put(SlasherVariants.GRABBER, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/grabber.png"));
    });
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/slasher.png");

    public SlasherRenderer(EntityRendererProvider.Context context) {
        super(context, new SlasherModel(context.bakeLayer(SlasherModel.LAYER_LOCATION)), 0.5f);
        this.defaultModel = this.model;
        this.smasher = new SmasherSlasherModel<Type>(context.bakeLayer(SmasherSlasherModel.LAYER_LOCATION));
        this.grabber = new GrabberSlasherModel(context.bakeLayer(GrabberSlasherModel.LAYER_LOCATION));
    }

    private EntityModel<Type> getDefaultModel(int i) {
        return switch (i) {
            case 2 -> this.smasher;
            case 3 -> this.grabber;
            default -> this.defaultModel;
        };
    }

    @Override
    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.model = this.getDefaultModel(((Slasher)type).getTypeVariant());
        super.render(type, value1, value2, stack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Slasher)entity).getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }
}

