/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.StingerModel;
import com.Harbinger.Spore.Sentities.Projectile.StingerProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StingerRenderer<T extends StingerProjectile>
extends EntityRenderer<T> {
    public static final ResourceLocation Spear_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/stinger.png");
    private final StingerModel<T> model = new StingerModel();

    public StingerRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T p_116111_, float p_116112_, float p_116113_, PoseStack stack, MultiBufferSource source, int p_116116_) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)p_116113_, (float)((StingerProjectile)((Object)p_116111_)).yRotO, (float)p_116111_.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)p_116113_, (float)((StingerProjectile)((Object)p_116111_)).xRotO, (float)p_116111_.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)this.model.renderType(this.getTextureLocation((StingerProjectile)((Object)p_116111_))), (boolean)false, (boolean)false);
        this.model.renderToBuffer(stack, vertexconsumer, p_116116_, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        super.render(p_116111_, p_116112_, p_116113_, stack, source, p_116116_);
    }

    public ResourceLocation getTextureLocation(StingerProjectile p_116109_) {
        return Spear_LOCATION;
    }
}

