/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.SyringeProjectileModel;
import com.Harbinger.Spore.Sentities.Projectile.SyringeProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SyringeRenderer
extends EntityRenderer<SyringeProjectile> {
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/syringe.png");
    private final SyringeProjectileModel<SyringeProjectile> model = new SyringeProjectileModel();

    public SyringeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SyringeProjectile spear, float p_116112_, float p_116113_, PoseStack stack, MultiBufferSource source, int p_116116_) {
        stack.pushPose();
        stack.translate(0.0f, -1.0f, 0.0f);
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)p_116113_, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)p_116113_, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = source.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(spear)));
        this.model.renderToBuffer(stack, vertexconsumer, p_116116_, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        super.render((Entity)spear, p_116112_, p_116113_, stack, source, p_116116_);
    }

    public ResourceLocation getTextureLocation(SyringeProjectile p_116109_) {
        return LOCATION;
    }
}

