/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.ThornModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Thorn;
import com.Harbinger.Spore.Sentities.Variants.ThornVariants;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThornRenderer<Type extends Thorn>
extends BaseInfectedRenderer<Type, ThornModel<Type>> {
    public static final Map<ThornVariants, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(ThornVariants.class), p_114874_ -> {
        p_114874_.put(ThornVariants.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/vervathorn.png"));
        p_114874_.put(ThornVariants.TOXIC, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/toxic_vervathorn.png"));
    });
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/vervathorn.png");

    public ThornRenderer(EntityRendererProvider.Context context) {
        super(context, new ThornModel(context.bakeLayer(ThornModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Thorn)entity).getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }
}

