/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.TintedBufferSource;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBoomerang;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThrownBoomerangRenderer
extends EntityRenderer<ThrownBoomerang> {
    private final ItemRenderer itemRenderer;

    public ThrownBoomerangRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ThrownBoomerang entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float ageInTicks = (float)entity.tickCount + partialTicks;
        int color = entity.getColor() == 0 ? -1 : entity.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        poseStack.translate(0.0, 0.15, 0.0);
        poseStack.scale(2.5f, 2.5f, 2.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(ageInTicks * 20.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        TintedBufferSource wrappedBuffer = new TintedBufferSource(buffer, r, g, b, 1.0f);
        this.itemRenderer.renderStatic(entity.getBoomerang().copy(), ItemDisplayContext.GROUND, packedLight, 0, poseStack, (MultiBufferSource)wrappedBuffer, entity.level(), entity.getId());
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ThrownBoomerang entity) {
        return null;
    }
}

