/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.VigilModel;
import com.Harbinger.Spore.Client.Models.VigilSignModel;
import com.Harbinger.Spore.Client.Special.OrganoidMobRenderer;
import com.Harbinger.Spore.Sentities.Organoids.Vigil;
import com.Harbinger.Spore.Sentities.Variants.VigilVariants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VigilRenderer<Type extends Vigil>
extends OrganoidMobRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel = this.getModel();
    private final EntityModel<Type> alterModel;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/vigil.png");
    private static final ResourceLocation STALKER = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/vigil_stalker.png");

    public VigilRenderer(EntityRendererProvider.Context context) {
        super(context, new VigilModel(context.bakeLayer(VigilModel.LAYER_LOCATION)), 1.0f);
        this.alterModel = new VigilSignModel<Type>(context.bakeLayer(VigilSignModel.LAYER_LOCATION));
        this.addLayer(new SignModel(this, context.getItemInHandRenderer()));
    }

    @Override
    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int value3) {
        this.model = ((Vigil)type).getVariant() == VigilVariants.TROLL ? this.alterModel : this.defaultModel;
        super.render(type, value1, value2, stack, bufferSource, value3);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Vigil)entity).isStalker() ? STALKER : TEXTURE;
    }

    protected void scale(Type type, PoseStack stack, float value) {
        if (((Vigil)type).isStalker()) {
            stack.scale(1.2f, 1.2f, 1.2f);
        }
        super.scale(type, stack, value);
    }

    private static class SignModel<T extends Vigil, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public SignModel(RenderLayerParent<T, M> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
            super(renderLayerParent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            EntityModel entityModel;
            if (((Vigil)t).getVariant() == VigilVariants.TROLL && (entityModel = this.getParentModel()) instanceof VigilSignModel) {
                VigilSignModel signModel = (VigilSignModel)entityModel;
                ItemStack stack = new ItemStack((ItemLike)Items.OAK_SIGN);
                poseStack.pushPose();
                for (ModelPart part : signModel.getArms()) {
                    part.translateAndRotate(poseStack);
                }
                poseStack.translate(0.3f, 0.1f, -0.4f);
                poseStack.scale(2.25f, 2.25f, 2.25f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                this.itemInHandRenderer.renderItem(t, stack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
                poseStack.popPose();
            }
        }
    }
}

