/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Special;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T>,
BlockEntityRendererProvider<T> {
    private final BlockEntityModel<T> model;

    protected BaseBlockEntityRenderer(BlockEntityModel<T> model) {
        this.model = model;
    }

    public abstract ResourceLocation getTexture(T var1);

    public BlockEntityModel<T> getModel() {
        return this.model;
    }

    public void render(@NotNull T blockEntity, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (!this.unRenderBlock(blockEntity)) {
            return;
        }
        pPoseStack.pushPose();
        float f = (float)((AnimatedEntity)blockEntity).getTicks() + partialTicks;
        VertexConsumer vertexConsumer = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTexture(blockEntity)));
        this.setModelScale(pPoseStack, blockEntity);
        this.model.setupAnim(blockEntity, f);
        this.model.renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
    }

    protected boolean unRenderBlock(T blockEntity) {
        Entity entity = Minecraft.getInstance().cameraEntity;
        if (entity instanceof Player) {
            int z;
            int y;
            Player player = (Player)entity;
            int x = blockEntity.getBlockPos().getX();
            double d0 = player.distanceToSqr((double)x, (double)(y = blockEntity.getBlockPos().getY()), (double)(z = blockEntity.getBlockPos().getZ()));
            return d0 < 256.0;
        }
        return false;
    }

    public void setModelScale(PoseStack pPoseStack, T block) {
        this.setModelScale(pPoseStack, block, 2);
    }

    public void setModelScale(PoseStack pPoseStack, T block, int value) {
        pPoseStack.translate(0.5, 1.5, 0.5);
        pPoseStack.scale(0.99f, 0.99f, 0.99f);
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        if (value == 2) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
        }
        if (value == 3) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        if (value == 4) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        }
        if (value == 5) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
    }

    public BlockEntityRenderer<T> create(BlockEntityRendererProvider.Context context) {
        return this;
    }
}

