/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Special;

import com.Harbinger.Spore.Client.Layers.EyeLayer;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.Seffects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public abstract class BaseInfectedRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final EntityRenderDispatcher entityRenderer;

    public BaseInfectedRenderer(EntityRendererProvider.Context context, M model, float shadow) {
        super(context, model, shadow);
        this.addLayer(new EyeLayer(this, this.eyeLayerTexture()));
        this.entityRenderer = context.getEntityRenderDispatcher();
    }

    public abstract ResourceLocation eyeLayerTexture();

    protected boolean isShaking(T type) {
        if (type instanceof Infected) {
            Infected infected = (Infected)((Object)type);
            return infected.isFreazing();
        }
        if (type instanceof Calamity) {
            Calamity calamity = (Calamity)type;
            return calamity.isStunned();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(T type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        Infected infected;
        if (type instanceof Infected && Objects.equals((infected = (Infected)((Object)type)).getOrigin(), "")) {
            super.render(type, value1, value2, stack, bufferSource, light);
            return;
        }
        if (type instanceof Infected) {
            infected = (Infected)((Object)type);
            Entity entity = Minecraft.getInstance().cameraEntity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                MobEffectInstance instance = player.getEffect(Seffects.MADNESS);
                Entity entityForm = this.getForm(infected);
                if (instance != null && instance.getAmplifier() > 0 && player.distanceTo((Entity)infected) > 30.0f && entityForm instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entityForm;
                    this.renderIllusions(living, infected, value2, stack, bufferSource, light);
                    return;
                }
                super.render(type, value1, value2, stack, bufferSource, light);
                return;
            }
        }
        super.render(type, value1, value2, stack, bufferSource, light);
    }

    protected float getBob(Infected illusion, float p_115306_) {
        return (float)illusion.tickCount + p_115306_;
    }

    public Entity getForm(Infected infected) {
        ResourceLocation location = ResourceLocation.parse((String)infected.getOrigin());
        EntityType<?> entityType = Utilities.tryToCreateEntity(location);
        return entityType != null ? entityType.create(infected.level()) : null;
    }

    public void renderIllusions(LivingEntity living, Infected infected, float value2, PoseStack stack, MultiBufferSource source, int light) {
        float f = Mth.rotLerp((float)value2, (float)infected.yBodyRotO, (float)infected.yBodyRot);
        float f1 = Mth.rotLerp((float)value2, (float)infected.yHeadRotO, (float)infected.yHeadRot);
        float f2 = f1 - f;
        float f6 = Mth.lerp((float)value2, (float)infected.xRotO, (float)infected.getXRot());
        float f7 = this.getBob(infected, value2);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (infected.isAlive()) {
            f8 = infected.walkAnimation.speed(value2);
            f5 = infected.walkAnimation.position(value2);
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        if (living != null) {
            stack.pushPose();
            stack.mulPose(Axis.YP.rotationDegrees(-infected.yBodyRot));
            stack.mulPose(Axis.XP.rotationDegrees(180.0f));
            stack.translate(0.0, -1.5, 0.0);
            EntityRenderer entityRenderer = this.entityRenderer.getRenderer((Entity)living);
            if (entityRenderer instanceof MobRenderer) {
                MobRenderer mobRenderer = (MobRenderer)entityRenderer;
                EntityModel model = mobRenderer.getModel();
                ResourceLocation texture = mobRenderer.getTextureLocation((Entity)living);
                VertexConsumer consumer = source.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
                model.prepareMobModel((Entity)living, f5, f8, value2);
                model.setupAnim((Entity)living, f5, f8, f7, f2, f6);
                model.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY, -1);
            }
            stack.popPose();
        }
    }
}

