/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TintedBufferSource
implements MultiBufferSource {
    private final MultiBufferSource original;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public TintedBufferSource(MultiBufferSource original, float r, float g, float b, float a) {
        this.original = original;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        return new TintedVertexConsumer(this.original.getBuffer(renderType), this.r, this.g, this.b, this.a);
    }

    public static class TintedVertexConsumer
    implements VertexConsumer {
        private final VertexConsumer base;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public TintedVertexConsumer(VertexConsumer base, float r, float g, float b, float a) {
            this.base = base;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static int clampColor(int v) {
            if (v < 0) {
                return 0;
            }
            return Math.min(v, 255);
        }

        private int applyTintToComponent(int component, float multiplier) {
            int val = (int)((float)component * multiplier);
            return TintedVertexConsumer.clampColor(val);
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            this.base.addVertex(x, y, z);
            return this;
        }

        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            int nr = this.applyTintToComponent(red, this.r);
            int ng = this.applyTintToComponent(green, this.g);
            int nb = this.applyTintToComponent(blue, this.b);
            int na = this.applyTintToComponent(alpha, this.a);
            this.base.setColor(nr, ng, nb, na);
            return this;
        }

        public VertexConsumer setUv(float u, float v) {
            this.base.setUv(u, v);
            return this;
        }

        public VertexConsumer setUv1(int u, int v) {
            this.base.setUv1(u, v);
            return this;
        }

        public VertexConsumer setUv2(int u, int v) {
            this.base.setUv2(u, v);
            return this;
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            this.base.setNormal(x, y, z);
            return this;
        }
    }
}

