/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Effect;

import com.Harbinger.Spore.Effect.SporeEffectsHandler;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Madness
extends MobEffect
implements SporeEffectsHandler {
    public Madness() {
        super(MobEffectCategory.HARMFUL, 419435);
    }

    public void feelingWatched(ServerPlayer player) {
        player.displayClientMessage((Component)Component.translatable((String)"vigil.message"), true);
    }

    public void SummonIllusion(LivingEntity entity, ServerLevel serverLevel, boolean value, int targetId) {
        int x = entity.getRandom().nextInt(-6, 6);
        int z = entity.getRandom().nextInt(-6, 6);
        Illusion illusion = new Illusion(Sentities.ILLUSION.get(), (Level)serverLevel);
        illusion.setSeeAble(false);
        illusion.setAdvanced(value);
        illusion.setTargetId(targetId);
        DifficultyInstance difficultyInstance = serverLevel.getCurrentDifficultyAt(entity.blockPosition());
        illusion.moveTo(entity.getX() + (double)x, entity.getY(), entity.getZ() + (double)z);
        illusion.finalizeSpawn((ServerLevelAccessor)serverLevel, difficultyInstance, MobSpawnType.MOB_SUMMONED, null);
        serverLevel.addFreshEntity((Entity)illusion);
    }

    public void playClientSounds(LivingEntity entity) {
        entity.playSound(Ssounds.MADNESS.get());
    }

    @Override
    public boolean isDurationEffectTick(int duration, int intensity) {
        return duration % 80 == 0;
    }

    @Override
    public void triggerEffects(LivingEntity entity, int intense) {
        Level level;
        if (Math.random() < (Double)SConfig.SERVER.chance_hallucination_spawn.get() * 0.01 && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (intense > 1 && intense < 4) {
                this.SummonIllusion(entity, serverLevel, false, entity.getId());
            }
            if (intense >= 4) {
                this.SummonIllusion(entity, serverLevel, true, entity.getId());
            }
        }
        if (Math.random() < 0.1) {
            this.playClientSounds(entity);
        }
        if (Math.random() < 0.1 && intense > 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.feelingWatched(player);
        }
    }
}

