/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Spore;
import com.Harbinger.Spore.core.SConfig;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class BiomeModification
implements BiomeModifier {
    public static final MapCodec<BiomeModification> CODEC = MapCodec.unit(BiomeModification::new);

    public static MapCodec<BiomeModification> makeCodec() {
        return CODEC;
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    private void addSpawns(ModifiableBiomeInfo.BiomeInfo.Builder builder, int modifier) {
        List spawnEntries = (List)SConfig.SERVER.spawns.get();
        for (String entry : spawnEntries) {
            String[] parts = entry.split("\\|");
            if (parts.length != 4) {
                Spore.LOGGER.warn("Invalid spawn entry: {}", (Object)entry);
                continue;
            }
            ResourceLocation id = ResourceLocation.parse((String)parts[0]);
            EntityType<?> type = Utilities.tryToCreateEntity(id);
            if (type == null) {
                Spore.LOGGER.warn("Unknown entity type: {}", (Object)parts[0]);
                continue;
            }
            try {
                int weight = Integer.parseInt(parts[1]) + modifier;
                int min = Integer.parseInt(parts[2]);
                int max = Integer.parseInt(parts[3]);
                builder.getMobSpawnSettings().getSpawner(type.getCategory()).add(new MobSpawnSettings.SpawnerData(type, weight, min, max));
            }
            catch (NumberFormatException e) {
                Spore.LOGGER.error("Invalid number in spawn config: {}", (Object)entry, (Object)e);
            }
        }
    }

    private boolean isBiomeBlacklisted(Holder<Biome> biome) {
        for (String blacklisted : (List)SConfig.SERVER.dimension_blacklist.get()) {
            ResourceLocation loc = ResourceLocation.parse((String)blacklisted);
            TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)loc);
            if (!biome.is(tag) && !biome.is(loc)) continue;
            return true;
        }
        return false;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (this.isBiomeBlacklisted(biome)) {
            return;
        }
        int biomeModifier = biome.is(Tags.Biomes.IS_MUSHROOM) ? 20 : 0;
        for (String allowedBiome : (List)SConfig.SERVER.dimension_parameters.get()) {
            ResourceLocation loc = ResourceLocation.parse((String)allowedBiome);
            TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)loc);
            if (!biome.is(tag) && !biome.is(loc)) continue;
            this.addSpawns(builder, biomeModifier);
            break;
        }
    }
}

