/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ChunkLoadRequest {
    private ChunkPos[] chunkPositionsToLoad;
    private int priority;
    private final String requestID;
    private final long tickAmount;
    private long ticksUntilExpiration;
    private final UUID ownerUUID;
    private final ResourceKey<Level> dimension;

    public ChunkLoadRequest(ResourceKey<Level> dimension, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration, UUID ownerUUID) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
        this.priority = priority;
        this.requestID = requestID;
        this.tickAmount = ticksUntilExpiration;
        this.ticksUntilExpiration = ticksUntilExpiration;
        this.ownerUUID = ownerUUID;
        this.dimension = dimension;
    }

    public ChunkPos[] getChunkPositionsToLoad() {
        return this.chunkPositionsToLoad;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTickAmount() {
        return this.tickAmount;
    }

    public ServerLevel getDimension() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? server.getLevel(this.dimension) : null;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public boolean isRequestID(String requestID) {
        return Objects.equals(this.requestID, requestID);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean isExpired() {
        return this.ticksUntilExpiration <= 0L;
    }

    public void decrementTicksUntilExpiration(int amountToDecrement) {
        this.ticksUntilExpiration -= (long)amountToDecrement;
    }

    public long getTicksUntilExpiration() {
        return this.ticksUntilExpiration;
    }

    private void setTicksUntilExpiration(long value) {
        this.ticksUntilExpiration = value;
    }

    public boolean isHigherPriorityThan(ChunkLoadRequest other) {
        return this.priority < other.priority;
    }

    public boolean doesContainChunk(ChunkPos chunkPos) {
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (!pos.equals((Object)chunkPos)) continue;
            return true;
        }
        return false;
    }

    public boolean isOwnerStillPresentInChunk() {
        if (this.ownerUUID == null) {
            return false;
        }
        ServerLevel level = this.getDimension();
        if (level == null) {
            return false;
        }
        Entity entity = level.getEntity(this.ownerUUID);
        if (entity == null || !entity.isAlive()) {
            return false;
        }
        ChunkPos entityPos = new ChunkPos(entity.blockPosition());
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (!pos.equals((Object)entityPos)) continue;
            return true;
        }
        return false;
    }

    public boolean refreshIfOwnerStillPresent(long newDurationTicks) {
        if (this.isOwnerStillPresentInChunk()) {
            this.ticksUntilExpiration = newDurationTicks;
            return true;
        }
        return false;
    }

    public void removeChunk(ChunkPos chunkPos) {
        if (!this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length - 1];
        int index = 0;
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (pos.equals((Object)chunkPos)) continue;
            newChunkPositionsToLoad[index++] = pos;
        }
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void addChunk(ChunkPos chunkPos) {
        if (this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length + 1];
        System.arraycopy(this.chunkPositionsToLoad, 0, newChunkPositionsToLoad, 0, this.chunkPositionsToLoad.length);
        newChunkPositionsToLoad[this.chunkPositionsToLoad.length] = chunkPos;
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void setChunkPositionsToLoad(ChunkPos[] chunkPositionsToLoad) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("RequestID", this.requestID);
        tag.putInt("Priority", this.priority);
        tag.putLong("TicksUntilExpiration", this.ticksUntilExpiration);
        tag.putLong("StartTickValue", this.tickAmount);
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        tag.putString("Dimension", this.dimension.location().toString());
        ListTag chunks = new ListTag();
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            CompoundTag c = new CompoundTag();
            c.putInt("X", pos.x);
            c.putInt("Z", pos.z);
            chunks.add((Object)c);
        }
        tag.put("Chunks", (Tag)chunks);
        return tag;
    }

    public static ChunkLoadRequest deserializeNBT(CompoundTag tag) {
        String requestID = tag.getString("RequestID");
        int priority = tag.getInt("Priority");
        long ticksUntilExpiration = tag.getLong("TicksUntilExpiration");
        long startTicks = tag.getLong("StartTickValue");
        UUID ownerUUID = tag.hasUUID("OwnerUUID") ? tag.getUUID("OwnerUUID") : null;
        ResourceKey dimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("Dimension")));
        ListTag chunksList = tag.getList("Chunks", 10);
        ChunkPos[] positions = new ChunkPos[chunksList.size()];
        for (int i = 0; i < chunksList.size(); ++i) {
            CompoundTag c = chunksList.getCompound(i);
            positions[i] = new ChunkPos(c.getInt("X"), c.getInt("Z"));
        }
        ChunkLoadRequest request = new ChunkLoadRequest((ResourceKey<Level>)dimKey, positions, priority, requestID, startTicks, ownerUUID);
        request.setTicksUntilExpiration(ticksUntilExpiration);
        return request;
    }

    public static void loadChunkData(ServerLevel level) {
        SporeSavedData data = SporeSavedData.get(level);
        for (ChunkLoadRequest request : data.getRequests()) {
            ChunkLoaderHelper.ACTIVE_REQUESTS.put(request.getRequestID(), request);
            for (ChunkPos pos : request.getChunkPositionsToLoad()) {
                ChunkLoaderHelper.forceChunk(level, pos);
            }
        }
    }
}

