/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings.Package;

import com.Harbinger.Spore.SBlockEntities.SurgeryTableBlockEntity;
import com.Harbinger.Spore.Screens.GraftingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenGraftingScreenPacket(BlockPos pos, int id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenGraftingScreenPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"open_grafting_screen"));
    public static final StreamCodec<FriendlyByteBuf, OpenGraftingScreenPacket> STREAM_CODEC = StreamCodec.of(OpenGraftingScreenPacket::encode, OpenGraftingScreenPacket::new);

    public OpenGraftingScreenPacket(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readInt());
    }

    private static void encode(FriendlyByteBuf friendlyByteBuf, OpenGraftingScreenPacket openGraftingScreenPacket) {
        friendlyByteBuf.writeBlockPos(openGraftingScreenPacket.pos);
        friendlyByteBuf.writeInt(openGraftingScreenPacket.id);
    }

    public static void handle(OpenGraftingScreenPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            if (level.isClientSide) {
                return;
            }
            Entity truePlayer = level.getEntity(msg.id);
            BlockEntity be = level.getBlockEntity(msg.pos);
            if (be instanceof SurgeryTableBlockEntity) {
                final SurgeryTableBlockEntity table = (SurgeryTableBlockEntity)be;
                if (truePlayer instanceof ServerPlayer) {
                    ServerPlayer trueP = (ServerPlayer)truePlayer;
                    trueP.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"block.spore.surgery_table");
                        }

                        public AbstractContainerMenu createMenu(int id, Inventory inv, Player ply) {
                            return new GraftingMenu(id, inv, table);
                        }

                        public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
                            super.writeClientSideData(menu, buffer);
                            buffer.writeBlockPos(table.getBlockPos());
                        }
                    });
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

