/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings.Package;

import com.Harbinger.Spore.ExtremelySusThings.Package.SyncAdvancementPacket;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestAdvancementPacket(String advancementId, int id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestAdvancementPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"request_advancement"));
    public static final StreamCodec<FriendlyByteBuf, RequestAdvancementPacket> STREAM_CODEC = StreamCodec.of(RequestAdvancementPacket::encode, RequestAdvancementPacket::new);

    public RequestAdvancementPacket(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readInt());
    }

    public static void encode(FriendlyByteBuf buffer, RequestAdvancementPacket packet) {
        buffer.writeUtf(packet.advancementId);
        buffer.writeInt(packet.id);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequestAdvancementPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            if (level.isClientSide) {
                return;
            }
            Entity truePlayer = level.getEntity(message.id);
            if (truePlayer instanceof ServerPlayer) {
                ServerPlayer playerValue = (ServerPlayer)truePlayer;
                MinecraftServer server = playerValue.server;
                AdvancementHolder holder = server.getAdvancements().get(ResourceLocation.parse((String)message.advancementId));
                if (holder == null) {
                    return;
                }
                boolean hasAdvancement = playerValue.getAdvancements().getOrStartProgress(holder).isDone();
                SporePacketHandler.sendToClient(new SyncAdvancementPacket(message.advancementId, hasAdvancement), playerValue);
            }
        });
    }
}

