/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings.Package;

import com.Harbinger.Spore.ExtremelySusThings.ClientAdvancementTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncAdvancementPacket(String advancementId, boolean hasAdvancement) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncAdvancementPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"sync_advancement"));
    public static final StreamCodec<FriendlyByteBuf, SyncAdvancementPacket> STREAM_CODEC = StreamCodec.of(SyncAdvancementPacket::encode, SyncAdvancementPacket::new);

    public SyncAdvancementPacket(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readBoolean());
    }

    public static void encode(FriendlyByteBuf buffer, SyncAdvancementPacket packet) {
        buffer.writeUtf(packet.advancementId);
        buffer.writeBoolean(packet.hasAdvancement);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncAdvancementPacket message, IPayloadContext context) {
        context.enqueueWork(() -> ClientAdvancementTracker.setAdvancement(message.advancementId, message.hasAdvancement));
    }
}

