/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SporeSavedData
extends SavedData {
    public static final Map<String, ChunkLoadRequest> activeRequests = new HashMap<String, ChunkLoadRequest>();
    public static final String NAME = "spore_world_data";
    private final List<Proto> hiveminds = new ArrayList<Proto>();
    private static final List<Protector> protectorList = new ArrayList<Protector>();

    public static void addProtector(Protector protector) {
        protectorList.add(protector);
    }

    public static void removeProtector(Protector protector) {
        protectorList.remove(protector);
    }

    public static List<Protector> protectorList() {
        return protectorList;
    }

    public static void addHivemind(ServerLevel level, Proto proto) {
        SporeSavedData data = (SporeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
        data.hiveminds.add(proto);
        data.setDirty();
    }

    public static void resetHive(ServerLevel level) {
        SporeSavedData data = (SporeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
        data.hiveminds.clear();
        data.setDirty();
    }

    public static void removeHivemind(ServerLevel level, Proto proto) {
        SporeSavedData data = (SporeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
        if (!data.hiveminds.isEmpty()) {
            data.hiveminds.remove(proto);
        }
        data.setDirty();
    }

    public static List<Proto> getHiveminds(ServerLevel level) {
        SporeSavedData data = (SporeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
        return data.hiveminds;
    }

    public int getAmountOfHiveminds() {
        return this.hiveminds.size();
    }

    public static SporeSavedData getDataLocation(ServerLevel level) {
        return (SporeSavedData)level.getDataStorage().get(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
    }

    public static SporeSavedData get(ServerLevel level) {
        return (SporeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SporeSavedData::new, SporeSavedData::load), NAME);
    }

    public void addRequest(ChunkLoadRequest request) {
        activeRequests.put(request.getRequestID(), request);
        this.setDirty();
    }

    public void removeRequest(String id) {
        activeRequests.remove(id);
        this.setDirty();
    }

    public Collection<ChunkLoadRequest> getRequests() {
        return activeRequests.values();
    }

    public static SporeSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        SporeSavedData data = new SporeSavedData();
        if (tag.contains("ChunkRequests", 9)) {
            ListTag list = tag.getList("ChunkRequests", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.getCompound(i);
                ChunkLoadRequest request = ChunkLoadRequest.deserializeNBT(entry);
                activeRequests.put(request.getRequestID(), request);
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag listTag = new ListTag();
        for (ChunkLoadRequest request : activeRequests.values()) {
            listTag.add((Object)request.serializeNBT());
        }
        tag.put("ChunkRequests", (Tag)listTag);
        return tag;
    }
}

